/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.signers;

import org.bitcoinj.base.ScriptType;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingSigResolutionSigner
implements TransactionSigner {
    private static final Logger log = LoggerFactory.getLogger(MissingSigResolutionSigner.class);
    private final Wallet.MissingSigsMode missingSigsMode;

    public MissingSigResolutionSigner() {
        this(Wallet.MissingSigsMode.USE_DUMMY_SIG);
    }

    public MissingSigResolutionSigner(Wallet.MissingSigsMode missingSigsMode) {
        this.missingSigsMode = missingSigsMode;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean signInputs(TransactionSigner.ProposedTransaction propTx, KeyBag keyBag) {
        if (this.missingSigsMode == Wallet.MissingSigsMode.USE_OP_ZERO) {
            return true;
        }
        int numInputs = propTx.partialTx.getInputs().size();
        byte[] dummySig = TransactionSignature.dummy().encodeToBitcoin();
        for (int i2 = 0; i2 < numInputs; ++i2) {
            TransactionInput txIn = propTx.partialTx.getInput(i2);
            if (txIn.getConnectedOutput() == null) {
                log.warn("Missing connected output, assuming input {} is already signed.", (Object)i2);
                continue;
            }
            Script scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
            Script inputScript = txIn.getScriptSig();
            if (ScriptPattern.isP2SH(scriptPubKey) || ScriptPattern.isSentToMultisig(scriptPubKey)) {
                int sigSuffixCount = ScriptPattern.isP2SH(scriptPubKey) ? 1 : 0;
                for (int j = 1; j < inputScript.chunks().size() - sigSuffixCount; ++j) {
                    ScriptChunk scriptChunk = inputScript.chunks().get(j);
                    if (!scriptChunk.equalsOpCode(0)) continue;
                    if (this.missingSigsMode == Wallet.MissingSigsMode.THROW) {
                        throw new TransactionSigner.MissingSignatureException();
                    }
                    if (this.missingSigsMode != Wallet.MissingSigsMode.USE_DUMMY_SIG) continue;
                    txIn = txIn.withScriptSig(scriptPubKey.getScriptSigWithSignature(inputScript, dummySig, j - 1));
                }
            } else if (ScriptPattern.isP2PK(scriptPubKey) || ScriptPattern.isP2PKH(scriptPubKey)) {
                if (inputScript.chunks().get(0).equalsOpCode(0)) {
                    if (this.missingSigsMode == Wallet.MissingSigsMode.THROW) {
                        throw new ECKey.MissingPrivateKeyException();
                    }
                    if (this.missingSigsMode == Wallet.MissingSigsMode.USE_DUMMY_SIG) {
                        txIn = txIn.withScriptSig(scriptPubKey.getScriptSigWithSignature(inputScript, dummySig, 0));
                    }
                }
            } else if (ScriptPattern.isP2WPKH(scriptPubKey)) {
                if (txIn.getWitness() == null || txIn.getWitness().equals(TransactionWitness.EMPTY) || txIn.getWitness().getPush(0).length == 0) {
                    if (this.missingSigsMode == Wallet.MissingSigsMode.THROW) {
                        throw new ECKey.MissingPrivateKeyException();
                    }
                    if (this.missingSigsMode == Wallet.MissingSigsMode.USE_DUMMY_SIG) {
                        ECKey key = keyBag.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2WH(scriptPubKey), ScriptType.P2WPKH);
                        txIn = txIn.withWitness(TransactionWitness.redeemP2WPKH(TransactionSignature.dummy(), key));
                    }
                }
            } else {
                throw new IllegalStateException("cannot handle: " + scriptPubKey);
            }
            propTx.partialTx.replaceInput(i2, txIn);
        }
        return true;
    }
}

