/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Random;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;

@VisibleForTesting
public class FakeTxBuilder {
    public static Transaction createFakeTx(Network network) {
        return FakeTxBuilder.createFakeTxWithoutChangeAddress(Coin.COIN, FakeTxBuilder.randomAddress(network));
    }

    @Deprecated
    public static Transaction createFakeTx(NetworkParameters params) {
        return FakeTxBuilder.createFakeTxWithoutChangeAddress(Coin.COIN, FakeTxBuilder.randomAddress(params.network()));
    }

    public static Transaction createFakeTxWithoutChange(TransactionOutput output) {
        Transaction prevTx = FakeTxBuilder.createFakeTx(Coin.COIN, FakeTxBuilder.randomKey());
        Transaction tx = new Transaction();
        tx.addOutput(output);
        tx.addInput(prevTx.getOutput(0L));
        return tx;
    }

    public static Transaction createFakeCoinbaseTx() {
        Transaction tx = Transaction.coinbase();
        TransactionOutput outputToMe = new TransactionOutput(tx, Coin.FIFTY_COINS, FakeTxBuilder.randomKey());
        Preconditions.checkState(tx.isCoinBase());
        tx.addOutput(outputToMe);
        return tx;
    }

    public static Transaction createFakeTxWithChangeAddress(Coin value, Address to, Address changeOutput) {
        Transaction t = new Transaction();
        TransactionOutput outputToMe = new TransactionOutput(t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(t, Coin.valueOf(1, 11), changeOutput);
        t.addOutput(change);
        Transaction prevTx = new Transaction();
        TransactionOutput prevOut = new TransactionOutput(prevTx, value, to);
        prevTx.addOutput(prevOut);
        TransactionInput in = t.addInput(prevOut);
        in = in.withScriptSig(ScriptBuilder.createInputScript(TransactionSignature.dummy()));
        t.replaceInput(t.getInputs().size() - 1, in);
        return FakeTxBuilder.roundTripTransaction(t);
    }

    public static Transaction createFakeTxWithoutChangeAddress(Coin value, Address to) {
        Transaction t = new Transaction();
        TransactionOutput outputToMe = new TransactionOutput(t, value, to);
        t.addOutput(outputToMe);
        long split = new Random().nextLong();
        if (split < 0L) {
            split *= -1L;
        }
        if (split == 0L) {
            split = 15L;
        }
        while (split > value.getValue()) {
            split /= 2L;
        }
        Transaction prevTx1 = new Transaction();
        TransactionOutput prevOut1 = new TransactionOutput(prevTx1, Coin.valueOf(split), to);
        prevTx1.addOutput(prevOut1);
        TransactionInput in1 = t.addInput(prevOut1);
        in1 = in1.withScriptSig(ScriptBuilder.createInputScript(TransactionSignature.dummy()));
        t.replaceInput(t.getInputs().size() - 1, in1);
        Transaction prevTx2 = new Transaction();
        TransactionOutput prevOut2 = new TransactionOutput(prevTx2, Coin.valueOf(value.getValue() - split), to);
        prevTx2.addOutput(prevOut2);
        TransactionInput in2 = t.addInput(prevOut2);
        in2 = in2.withScriptSig(ScriptBuilder.createInputScript(TransactionSignature.dummy()));
        t.replaceInput(t.getInputs().size() - 1, in2);
        return FakeTxBuilder.roundTripTransaction(t);
    }

    public static Transaction createFakeTx(Network network, Coin value, Address to) {
        return FakeTxBuilder.createFakeTxWithChangeAddress(value, to, FakeTxBuilder.randomAddress(network));
    }

    @Deprecated
    public static Transaction createFakeTx(NetworkParameters params, Coin value, Address to) {
        return FakeTxBuilder.createFakeTx(params.network(), value, to);
    }

    public static Transaction createFakeTx(Coin value, ECKey to) {
        Transaction t = new Transaction();
        TransactionOutput outputToMe = new TransactionOutput(t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(t, Coin.valueOf(1, 11), new ECKey());
        t.addOutput(change);
        Transaction prevTx = new Transaction();
        TransactionOutput prevOut = new TransactionOutput(prevTx, value, to);
        prevTx.addOutput(prevOut);
        t.addInput(prevOut);
        return FakeTxBuilder.roundTripTransaction(t);
    }

    public static Transaction[] createFakeTx(Coin value, Address to, Address from) {
        Transaction t = new Transaction();
        TransactionOutput outputToMe = new TransactionOutput(t, value, to);
        t.addOutput(outputToMe);
        TransactionOutput change = new TransactionOutput(t, Coin.valueOf(1, 11), FakeTxBuilder.randomKey());
        t.addOutput(change);
        Transaction feederTx = new Transaction();
        TransactionOutput feederOut = new TransactionOutput(feederTx, value, from);
        feederTx.addOutput(feederOut);
        Transaction prevTx = new Transaction();
        TransactionOutput prevOut = new TransactionOutput(prevTx, value, to);
        prevTx.addOutput(prevOut);
        prevTx.addInput(feederOut);
        t.addInput(prevOut);
        return new Transaction[]{FakeTxBuilder.roundTripTransaction(prevTx), FakeTxBuilder.roundTripTransaction(t)};
    }

    public static Transaction roundTripTransaction(Transaction tx) {
        return Transaction.read(ByteBuffer.wrap(tx.serialize()));
    }

    public static DoubleSpends createFakeDoubleSpendTxns(Address to) {
        DoubleSpends doubleSpends = new DoubleSpends();
        Coin value = Coin.COIN;
        ECKey someBadGuy = FakeTxBuilder.randomKey();
        doubleSpends.prevTx = new Transaction();
        TransactionOutput prevOut = new TransactionOutput(doubleSpends.prevTx, value, someBadGuy);
        doubleSpends.prevTx.addOutput(prevOut);
        doubleSpends.t1 = new Transaction();
        TransactionOutput o1 = new TransactionOutput(doubleSpends.t1, value, to);
        doubleSpends.t1.addOutput(o1);
        doubleSpends.t1.addInput(prevOut);
        doubleSpends.t2 = new Transaction();
        doubleSpends.t2.addInput(prevOut);
        TransactionOutput o2 = new TransactionOutput(doubleSpends.t2, value, someBadGuy);
        doubleSpends.t2.addOutput(o2);
        try {
            doubleSpends.t1 = FakeTxBuilder.roundTripTransaction(doubleSpends.t1);
            doubleSpends.t2 = FakeTxBuilder.roundTripTransaction(doubleSpends.t2);
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        return doubleSpends;
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, long version, Instant time, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, version, time, 0, transactions);
    }

    @Deprecated
    public static BlockPair createFakeBlock(BlockStore blockStore, long version, long timeSecs, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, version, Instant.ofEpochSecond(timeSecs), transactions);
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, StoredBlock previousStoredBlock, long version, Instant time, int height, Transaction ... transactions) {
        try {
            Block previousBlock = previousStoredBlock.getHeader();
            Block b = previousBlock.createNextBlock(null, version, time, height);
            for (Transaction tx : transactions) {
                tx.getConfidence().maybeSetSourceToNetwork();
                b.addTransaction(tx);
            }
            b.solve();
            BlockPair pair = new BlockPair(b, previousStoredBlock.build(b));
            blockStore.put(pair.storedBlock);
            blockStore.setChainHead(pair.storedBlock);
            return pair;
        }
        catch (VerificationException | BlockStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static BlockPair createFakeBlock(BlockStore blockStore, StoredBlock previousStoredBlock, long version, long timeSecs, int height, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, previousStoredBlock, version, Instant.ofEpochSecond(timeSecs), height, transactions);
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, StoredBlock previousStoredBlock, int height, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, previousStoredBlock, 3L, TimeUtils.currentTime(), height, transactions);
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, long version, Instant time, int height, Transaction ... transactions) {
        try {
            return FakeTxBuilder.createFakeBlock(blockStore, blockStore.getChainHead(), version, time, height, transactions);
        }
        catch (BlockStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static BlockPair createFakeBlock(BlockStore blockStore, long version, long timeSecs, int height, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, version, Instant.ofEpochSecond(timeSecs), height, transactions);
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, int height, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, 1L, TimeUtils.currentTime(), height, transactions);
    }

    public static BlockPair createFakeBlock(BlockStore blockStore, Transaction ... transactions) {
        return FakeTxBuilder.createFakeBlock(blockStore, 1L, TimeUtils.currentTime(), 0, transactions);
    }

    public static Block makeSolvedTestBlock(BlockStore blockStore, Address coinsTo) throws BlockStoreException {
        Block b = blockStore.getChainHead().getHeader().createNextBlock(coinsTo);
        b.solve();
        return b;
    }

    public static Block makeSolvedTestBlock(Block prev, Transaction ... transactions) throws BlockStoreException {
        return FakeTxBuilder.makeSolvedTestBlock(prev, null, transactions);
    }

    public static Block makeSolvedTestBlock(Block prev, @Nullable Address to, Transaction ... transactions) throws BlockStoreException {
        Block b = prev.createNextBlock(to);
        for (Transaction tx : transactions) {
            b.addTransaction(tx);
        }
        b.solve();
        return b;
    }

    private static Address randomAddress(Network network) {
        return FakeTxBuilder.randomKey().toAddress(ScriptType.P2PKH, network);
    }

    private static ECKey randomKey() {
        return new ECKey();
    }

    public static class DoubleSpends {
        public Transaction t1;
        public Transaction t2;
        public Transaction prevTx;
    }

    public static class BlockPair {
        public final Block block;
        public final StoredBlock storedBlock;

        public BlockPair(Block block, StoredBlock storedBlock) {
            this.storedBlock = storedBlock;
            this.block = block;
        }
    }
}

