/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bitcoinj.base.internal.PlatformUtils;

public class AppDataDirectory {
    public static Path get(String appName) {
        Path applicationDataDirectory = AppDataDirectory.getPath(appName);
        try {
            Files.createDirectories(applicationDataDirectory, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't find/create AppDataDirectory", ioe);
        }
        return applicationDataDirectory;
    }

    public static Path getPath(String appName) {
        Path applicationDataDirectory = PlatformUtils.isWindows() ? AppDataDirectory.pathOf(System.getenv("APPDATA"), appName.toLowerCase()) : (PlatformUtils.isMac() ? AppDataDirectory.pathOf(System.getProperty("user.home"), "Library/Application Support", appName) : (PlatformUtils.isLinux() ? AppDataDirectory.pathOf(System.getProperty("user.home"), "." + appName.toLowerCase()) : AppDataDirectory.pathOf(System.getProperty("user.home"), "." + appName.toLowerCase())));
        return applicationDataDirectory;
    }

    private static Path pathOf(String first, String ... additional) {
        return FileSystems.getDefault().getPath(first, additional);
    }
}

