/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.utils.AppDataDirectory;

public class BlockFileLoader
implements Iterable<Block> {
    private static final int BLOCKFILE_BUFFER_SIZE = 0x1000000;
    private final List<File> files;
    private final long packetMagic;
    private final MessageSerializer serializer;

    public static List<File> getReferenceClientBlockFileList(File blocksDir) {
        File file;
        Preconditions.checkArgument(blocksDir.isDirectory(), () -> "not a directory: " + blocksDir);
        LinkedList<File> list = new LinkedList<File>();
        int i2 = 0;
        while ((file = new File(blocksDir, String.format(Locale.US, "blk%05d.dat", i2))).exists()) {
            list.add(file);
            ++i2;
        }
        return list;
    }

    public static List<File> getReferenceClientBlockFileList() {
        return BlockFileLoader.getReferenceClientBlockFileList(BlockFileLoader.defaultBlocksDir());
    }

    public static File defaultBlocksDir() {
        File defaultBlocksDir = AppDataDirectory.getPath("Bitcoin").resolve("blocks").toFile();
        if (!defaultBlocksDir.isDirectory()) {
            throw new RuntimeException("Default blocks directory not found");
        }
        return defaultBlocksDir;
    }

    public BlockFileLoader(Network network, File blocksDir) {
        this(network, BlockFileLoader.getReferenceClientBlockFileList(blocksDir));
    }

    public BlockFileLoader(Network network, List<File> files) {
        this.files = files;
        NetworkParameters params = NetworkParameters.of(network);
        this.packetMagic = params.getPacketMagic();
        this.serializer = params.getDefaultSerializer();
    }

    @Deprecated
    public BlockFileLoader(NetworkParameters params, File blocksDir) {
        this(params.network(), BlockFileLoader.getReferenceClientBlockFileList(blocksDir));
    }

    @Deprecated
    public BlockFileLoader(NetworkParameters params, List<File> files) {
        this.files = files;
        this.packetMagic = params.getPacketMagic();
        this.serializer = params.getDefaultSerializer();
    }

    @Override
    public Iterator<Block> iterator() {
        return this.stream().iterator();
    }

    public Stream<Block> stream() {
        return this.streamBuffers().map(this.serializer::makeBlock);
    }

    public Stream<ByteBuffer> streamBuffers() {
        return this.files.stream().flatMap(this::fileBlockStream);
    }

    protected Stream<ByteBuffer> fileBlockStream(File file) {
        return StreamSupport.stream(this.fileBlockSpliterator(file), false);
    }

    protected Spliterator<ByteBuffer> fileBlockSpliterator(File file) {
        try {
            BlockFileIterator iterator2 = new BlockFileIterator(file);
            int characteristics = 17;
            return Spliterators.spliteratorUnknownSize(iterator2, characteristics);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public class BlockFileIterator
    implements Iterator<ByteBuffer> {
        private final File file;
        private final BufferedInputStream currentFileStream;
        private ByteBuffer nextBlock = null;

        public BlockFileIterator(File blockFile) throws FileNotFoundException {
            this.file = blockFile;
            this.currentFileStream = new BufferedInputStream(new FileInputStream(blockFile), 0x1000000);
        }

        @Override
        public boolean hasNext() {
            if (this.nextBlock == null) {
                this.loadNextBlock();
            }
            return this.nextBlock != null;
        }

        @Override
        public ByteBuffer next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ByteBuffer next = this.nextBlock;
            this.nextBlock = null;
            return next;
        }

        private void loadNextBlock() {
            try {
                byte[] sizeBytes;
                int sizeBytesRead;
                if (this.currentFileStream.available() < 1) {
                    this.nextBlock = null;
                    return;
                }
                int nextChar = this.currentFileStream.read();
                while (nextChar != -1) {
                    if ((long)nextChar != (BlockFileLoader.this.packetMagic >>> 24 & 0xFFL)) {
                        nextChar = this.currentFileStream.read();
                        continue;
                    }
                    nextChar = this.currentFileStream.read();
                    if ((long)nextChar != (BlockFileLoader.this.packetMagic >>> 16 & 0xFFL) || (long)(nextChar = this.currentFileStream.read()) != (BlockFileLoader.this.packetMagic >>> 8 & 0xFFL) || (long)(nextChar = this.currentFileStream.read()) != (BlockFileLoader.this.packetMagic & 0xFFL)) continue;
                }
                if ((sizeBytesRead = this.currentFileStream.read(sizeBytes = new byte[4], 0, 4)) != 4) {
                    this.nextBlock = null;
                    return;
                }
                long size = ByteUtils.readUint32(sizeBytes, 0);
                byte[] dataBytes = new byte[(int)size];
                int dataBytesRead = this.currentFileStream.read(dataBytes, 0, (int)size);
                if ((long)dataBytesRead != size) {
                    this.nextBlock = null;
                    return;
                }
                try {
                    this.nextBlock = ByteBuffer.wrap(dataBytes);
                }
                catch (ProtocolException e) {
                    this.nextBlock = null;
                }
                catch (Exception e) {
                    throw new RuntimeException("unexpected problem with block in " + this.file, e);
                }
            }
            catch (IOException e) {
                this.nextBlock = null;
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

