/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import java.time.Duration;
import java.time.Instant;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;

public class ExponentialBackoff
implements Comparable<ExponentialBackoff> {
    public static final Duration DEFAULT_INITIAL_INTERVAL = Duration.ofMillis(100L);
    public static final float DEFAULT_MULTIPLIER = 1.1f;
    public static final Duration DEFAULT_MAXIMUM_INTERVAL = Duration.ofSeconds(30L);
    private Duration backoff;
    private Instant retryTime;
    private final Params params;

    public ExponentialBackoff(Params params) {
        this.params = params;
        this.trackSuccess();
    }

    public final void trackSuccess() {
        this.backoff = this.params.initialInterval;
        this.retryTime = TimeUtils.currentTime();
    }

    public void trackFailure() {
        this.retryTime = TimeUtils.currentTime().plus(this.backoff);
        this.backoff = Duration.ofMillis((long)((float)this.backoff.toMillis() * this.params.multiplier));
        if (this.backoff.compareTo(this.params.maximumInterval) > 0) {
            this.backoff = this.params.maximumInterval;
        }
    }

    public Instant retryTime() {
        return this.retryTime;
    }

    @Deprecated
    public long getRetryTime() {
        return this.retryTime.toEpochMilli();
    }

    @Override
    public int compareTo(ExponentialBackoff other) {
        return this.retryTime.compareTo(other.retryTime);
    }

    public String toString() {
        return "ExponentialBackoff retry=" + this.retryTime + " backoff=" + this.backoff.toMillis() + " ms";
    }

    public static class Params {
        private final Duration initialInterval;
        private final float multiplier;
        private final Duration maximumInterval;

        public Params(Duration initialInterval, float multiplier, Duration maximumInterval) {
            Preconditions.checkArgument(multiplier > 1.0f, () -> "multiplier must be greater than 1.0: " + multiplier);
            Preconditions.checkArgument(maximumInterval.compareTo(initialInterval) >= 0, () -> "maximum must not be less than initial: " + maximumInterval);
            this.initialInterval = initialInterval;
            this.multiplier = multiplier;
            this.maximumInterval = maximumInterval;
        }

        public Params() {
            this.initialInterval = DEFAULT_INITIAL_INTERVAL;
            this.multiplier = 1.1f;
            this.maximumInterval = DEFAULT_MAXIMUM_INTERVAL;
        }
    }
}

