/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class ListenerRegistration<T> {
    public final T listener;
    public final Executor executor;

    public ListenerRegistration(T listener, Executor executor) {
        this.listener = Objects.requireNonNull(listener);
        this.executor = Objects.requireNonNull(executor);
    }

    public static <T> boolean removeFromList(T listener, List<? extends ListenerRegistration<T>> list) {
        Objects.requireNonNull(listener);
        Optional<ListenerRegistration> optRegistration = list.stream().filter(r -> r.listener == listener).findFirst();
        Optional<Boolean> optBool = optRegistration.map(list::remove);
        return optBool.orElse(false);
    }
}

