/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.internal.StreamUtils;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.wallet.CoinSelection;

@FunctionalInterface
public interface CoinSelector {
    public CoinSelection select(Coin var1, List<TransactionOutput> var2);

    public static CoinSelector fromPredicate(Predicate<TransactionOutput> predicate) {
        return (target, candidates) -> candidates.stream().filter(predicate).collect(Collectors.collectingAndThen(StreamUtils.toUnmodifiableList(), CoinSelection::new));
    }
}

