/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.crypto.AesKey;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;

public class DecryptingKeyBag
implements KeyBag {
    protected final KeyBag target;
    protected final AesKey aesKey;

    public DecryptingKeyBag(KeyBag target, @Nullable AesKey aesKey) {
        this.target = Objects.requireNonNull(target);
        this.aesKey = aesKey;
    }

    @Nullable
    private ECKey maybeDecrypt(ECKey key) {
        if (key == null) {
            return null;
        }
        if (key.isEncrypted()) {
            if (this.aesKey == null) {
                throw new ECKey.KeyIsEncryptedException();
            }
            return key.decrypt(this.aesKey);
        }
        return key;
    }

    private RedeemData maybeDecrypt(RedeemData redeemData) {
        ArrayList<ECKey> decryptedKeys = new ArrayList<ECKey>();
        for (ECKey key : redeemData.keys) {
            decryptedKeys.add(this.maybeDecrypt(key));
        }
        return RedeemData.of(decryptedKeys, redeemData.redeemScript);
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKeyHash(byte[] pubKeyHash, @Nullable ScriptType scriptType) {
        return this.maybeDecrypt(this.target.findKeyFromPubKeyHash(pubKeyHash, scriptType));
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubKey) {
        return this.maybeDecrypt(this.target.findKeyFromPubKey(pubKey));
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
        return this.maybeDecrypt(this.target.findRedeemDataFromScriptHash(scriptHash));
    }
}

