/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Network;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;

public class DefaultCoinSelector
implements CoinSelector {
    private final Network network;

    protected DefaultCoinSelector() {
        this.network = null;
    }

    private DefaultCoinSelector(Network network) {
        this.network = network;
    }

    @Override
    public CoinSelection select(Coin target, List<TransactionOutput> candidates) {
        ArrayList<TransactionOutput> selected = new ArrayList<TransactionOutput>();
        ArrayList<TransactionOutput> sortedOutputs = new ArrayList<TransactionOutput>(candidates);
        if (!target.equals(BitcoinNetwork.MAX_MONEY)) {
            sortedOutputs.sort(DefaultCoinSelector::compareByDepth);
        }
        long total = 0L;
        for (TransactionOutput output : sortedOutputs) {
            if (total >= target.value) break;
            if (!this.shouldSelect(output.getParentTransaction())) continue;
            selected.add(output);
            total = Math.addExact(total, output.getValue().value);
        }
        return new CoinSelection(selected);
    }

    public static int compareByDepth(TransactionOutput a, TransactionOutput b) {
        int depth1 = a.getParentTransactionDepthInBlocks();
        int depth2 = b.getParentTransactionDepthInBlocks();
        Coin aValue = a.getValue();
        Coin bValue = b.getValue();
        BigInteger aCoinDepth = BigInteger.valueOf(aValue.value).multiply(BigInteger.valueOf(depth1));
        BigInteger bCoinDepth = BigInteger.valueOf(bValue.value).multiply(BigInteger.valueOf(depth2));
        int c1 = bCoinDepth.compareTo(aCoinDepth);
        if (c1 != 0) {
            return c1;
        }
        int c2 = bValue.compareTo(aValue);
        if (c2 != 0) {
            return c2;
        }
        BigInteger aHash = a.getParentTransactionHash().toBigInteger();
        BigInteger bHash = b.getParentTransactionHash().toBigInteger();
        return aHash.compareTo(bHash);
    }

    @Deprecated
    static void sortOutputs(ArrayList<TransactionOutput> outputs) {
        outputs.sort(DefaultCoinSelector::compareByDepth);
    }

    protected boolean shouldSelect(Transaction tx) {
        if (tx != null) {
            return DefaultCoinSelector.isSelectable(tx, this.network);
        }
        return true;
    }

    public static boolean isSelectable(Transaction tx, Network network) {
        TransactionConfidence confidence = tx.getConfidence();
        TransactionConfidence.ConfidenceType type = confidence.getConfidenceType();
        return type.equals((Object)TransactionConfidence.ConfidenceType.BUILDING) || type.equals((Object)TransactionConfidence.ConfidenceType.PENDING) && confidence.getSource().equals((Object)TransactionConfidence.Source.SELF) && (confidence.numBroadcastPeers() > 0 || network == BitcoinNetwork.REGTEST);
    }

    public static CoinSelector get(Network network) {
        return new DefaultCoinSelector(network);
    }
}

