/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.List;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.UnreadableWalletException;

public class DefaultKeyChainFactory
implements KeyChainFactory {
    @Override
    public DeterministicKeyChain makeKeyChain(DeterministicSeed seed, KeyCrypter crypter, ScriptType outputScriptType, List<ChildNumber> accountPath) {
        return new DeterministicKeyChain(seed, crypter, outputScriptType, accountPath);
    }

    @Override
    public DeterministicKeyChain makeWatchingKeyChain(DeterministicKey accountKey, ScriptType outputScriptType) throws UnreadableWalletException {
        return ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().watch(accountKey)).outputScriptType(outputScriptType)).build();
    }

    @Override
    public DeterministicKeyChain makeSpendingKeyChain(DeterministicKey accountKey, ScriptType outputScriptType) throws UnreadableWalletException {
        return ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(outputScriptType)).build();
    }
}

