/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.MoreObjects;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bitcoinj.base.internal.ByteUtils;
import org.bitcoinj.base.internal.InternalUtils;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.crypto.AesKey;
import org.bitcoinj.crypto.EncryptableItem;
import org.bitcoinj.crypto.EncryptedData;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bitcoinj.protobuf.wallet.Protos;

public class DeterministicSeed
implements EncryptableItem {
    public static final int DEFAULT_SEED_ENTROPY_BITS = 128;
    public static final int MAX_SEED_ENTROPY_BITS = 512;
    @Nullable
    private final byte[] seed;
    @Nullable
    private final List<String> mnemonicCode;
    @Nullable
    private final EncryptedData encryptedMnemonicCode;
    @Nullable
    private final EncryptedData encryptedSeed;
    @Nullable
    private Instant creationTime = null;

    public static DeterministicSeed ofMnemonic(String mnemonicCode, String passphrase, Instant creationTime) {
        return new DeterministicSeed(mnemonicCode, null, passphrase, Objects.requireNonNull(creationTime));
    }

    public static DeterministicSeed ofMnemonic(String mnemonicCode, String passphrase) {
        return new DeterministicSeed(mnemonicCode, null, passphrase, null);
    }

    public static DeterministicSeed ofMnemonic(List<String> mnemonicCode, String passphrase, Instant creationTime) {
        return new DeterministicSeed(mnemonicCode, null, passphrase, Objects.requireNonNull(creationTime));
    }

    public static DeterministicSeed ofMnemonic(List<String> mnemonicCode, String passphrase) {
        return new DeterministicSeed(mnemonicCode, null, passphrase, null);
    }

    public static DeterministicSeed ofEntropy(byte[] entropy, String passphrase, Instant creationTime) {
        return new DeterministicSeed(entropy, passphrase, Objects.requireNonNull(creationTime));
    }

    public static DeterministicSeed ofEntropy(byte[] entropy, String passphrase) {
        return new DeterministicSeed(entropy, passphrase, null);
    }

    public static DeterministicSeed ofRandom(SecureRandom random, int bits, String passphrase) {
        return new DeterministicSeed(random, bits, passphrase);
    }

    DeterministicSeed(String mnemonicString, byte[] seed, String passphrase, @Nullable Instant creationTime) {
        this(DeterministicSeed.decodeMnemonicCode(mnemonicString), seed, passphrase, creationTime);
    }

    @Deprecated
    public DeterministicSeed(String mnemonicString, byte[] seed, String passphrase, long creationTimeSecs) {
        this(mnemonicString, seed, passphrase, creationTimeSecs > 0L ? Instant.ofEpochSecond(creationTimeSecs) : null);
    }

    private DeterministicSeed(byte[] seed, List<String> mnemonic, @Nullable Instant creationTime) {
        this.seed = Objects.requireNonNull(seed);
        this.mnemonicCode = Objects.requireNonNull(mnemonic);
        this.encryptedMnemonicCode = null;
        this.encryptedSeed = null;
        this.creationTime = creationTime;
    }

    DeterministicSeed(EncryptedData encryptedMnemonic, @Nullable EncryptedData encryptedSeed, @Nullable Instant creationTime) {
        this.seed = null;
        this.mnemonicCode = null;
        this.encryptedMnemonicCode = Objects.requireNonNull(encryptedMnemonic);
        this.encryptedSeed = encryptedSeed;
        this.creationTime = creationTime;
    }

    @Deprecated
    public DeterministicSeed(EncryptedData encryptedMnemonic, @Nullable EncryptedData encryptedSeed, long creationTimeSecs) {
        this(encryptedMnemonic, encryptedSeed, creationTimeSecs > 0L ? Instant.ofEpochSecond(creationTimeSecs) : null);
    }

    private DeterministicSeed(List<String> mnemonicCode, @Nullable byte[] seed, String passphrase, @Nullable Instant creationTime) {
        this(seed != null ? seed : MnemonicCode.toSeed(mnemonicCode, Objects.requireNonNull(passphrase)), mnemonicCode, creationTime);
    }

    @Deprecated
    public DeterministicSeed(List<String> mnemonicCode, @Nullable byte[] seed, String passphrase, long creationTimeSecs) {
        this(mnemonicCode, seed, passphrase, creationTimeSecs > 0L ? Instant.ofEpochSecond(creationTimeSecs) : null);
    }

    @Deprecated
    public DeterministicSeed(SecureRandom random, int bits, String passphrase) {
        this(DeterministicSeed.getEntropy(random, bits), Objects.requireNonNull(passphrase), TimeUtils.currentTime().truncatedTo(ChronoUnit.SECONDS));
    }

    private DeterministicSeed(byte[] entropy, String passphrase, @Nullable Instant creationTime) {
        Preconditions.checkArgument(entropy.length * 8 >= 128, () -> "entropy size too small");
        Objects.requireNonNull(passphrase);
        this.mnemonicCode = MnemonicCode.INSTANCE.toMnemonic(entropy);
        this.seed = MnemonicCode.toSeed(this.mnemonicCode, passphrase);
        this.encryptedMnemonicCode = null;
        this.encryptedSeed = null;
        this.creationTime = creationTime;
    }

    @Deprecated
    public DeterministicSeed(byte[] entropy, String passphrase, long creationTimeSecs) {
        this(entropy, passphrase, creationTimeSecs > 0L ? Instant.ofEpochSecond(creationTimeSecs) : null);
    }

    private static byte[] getEntropy(SecureRandom random, int bits) {
        Preconditions.checkArgument(bits <= 512, () -> "requested entropy size too large");
        byte[] seed = new byte[bits / 8];
        random.nextBytes(seed);
        return seed;
    }

    @Override
    public boolean isEncrypted() {
        Preconditions.checkState(this.mnemonicCode != null || this.encryptedMnemonicCode != null);
        return this.encryptedMnemonicCode != null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includePrivate) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        if (this.isEncrypted()) {
            helper.addValue((Object)"encrypted");
        } else if (includePrivate) {
            helper.addValue((Object)this.toHexString()).add("mnemonicCode", (Object)this.getMnemonicString());
        } else {
            helper.addValue((Object)"unencrypted");
        }
        return helper.toString();
    }

    @Nullable
    public String toHexString() {
        return this.seed != null ? ByteUtils.formatHex(this.seed) : null;
    }

    @Override
    @Nullable
    public byte[] getSecretBytes() {
        return this.getMnemonicAsBytes();
    }

    @Nullable
    public byte[] getSeedBytes() {
        return this.seed;
    }

    @Override
    @Nullable
    public EncryptedData getEncryptedData() {
        return this.encryptedMnemonicCode;
    }

    @Override
    public Protos.Wallet.EncryptionType getEncryptionType() {
        return Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES;
    }

    @Nullable
    public EncryptedData getEncryptedSeedData() {
        return this.encryptedSeed;
    }

    @Override
    public Optional<Instant> getCreationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = Objects.requireNonNull(creationTime);
    }

    public void clearCreationTime() {
        this.creationTime = null;
    }

    @Deprecated
    public void setCreationTimeSeconds(long creationTimeSecs) {
        if (creationTimeSecs > 0L) {
            this.setCreationTime(Instant.ofEpochSecond(creationTimeSecs));
        } else if (creationTimeSecs == 0L) {
            this.clearCreationTime();
        } else {
            throw new IllegalArgumentException("Cannot set creation time to negative value: " + creationTimeSecs);
        }
    }

    public DeterministicSeed encrypt(KeyCrypter keyCrypter, AesKey aesKey) {
        Preconditions.checkState(this.encryptedMnemonicCode == null, () -> "trying to encrypt seed twice");
        Preconditions.checkState(this.mnemonicCode != null, () -> "mnemonic missing so cannot encrypt");
        EncryptedData encryptedMnemonic = keyCrypter.encrypt(this.getMnemonicAsBytes(), aesKey);
        EncryptedData encryptedSeed = keyCrypter.encrypt(this.seed, aesKey);
        return new DeterministicSeed(encryptedMnemonic, encryptedSeed, this.creationTime);
    }

    private byte[] getMnemonicAsBytes() {
        return this.getMnemonicString().getBytes(StandardCharsets.UTF_8);
    }

    public DeterministicSeed decrypt(KeyCrypter crypter, String passphrase, AesKey aesKey) {
        Preconditions.checkState(this.isEncrypted());
        Objects.requireNonNull(this.encryptedMnemonicCode);
        List<String> mnemonic = DeterministicSeed.decodeMnemonicCode(crypter.decrypt(this.encryptedMnemonicCode, aesKey));
        byte[] seed = this.encryptedSeed == null ? null : crypter.decrypt(this.encryptedSeed, aesKey);
        return new DeterministicSeed(mnemonic, seed, passphrase, this.creationTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeterministicSeed other = (DeterministicSeed)o;
        return Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.encryptedMnemonicCode, other.encryptedMnemonicCode) && Objects.equals(this.mnemonicCode, other.mnemonicCode);
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.encryptedMnemonicCode, this.mnemonicCode);
    }

    public void check() throws MnemonicException {
        if (this.mnemonicCode != null) {
            MnemonicCode.INSTANCE.check(this.mnemonicCode);
        }
    }

    byte[] getEntropyBytes() throws MnemonicException {
        return MnemonicCode.INSTANCE.toEntropy(this.mnemonicCode);
    }

    @Nullable
    public List<String> getMnemonicCode() {
        return this.mnemonicCode;
    }

    @Nullable
    public String getMnemonicString() {
        return this.mnemonicCode != null ? InternalUtils.SPACE_JOINER.join(this.mnemonicCode) : null;
    }

    private static List<String> decodeMnemonicCode(byte[] mnemonicCode) {
        return DeterministicSeed.decodeMnemonicCode(new String(mnemonicCode, StandardCharsets.UTF_8));
    }

    private static List<String> decodeMnemonicCode(String mnemonicCode) {
        return InternalUtils.WHITESPACE_SPLITTER.splitToList(mnemonicCode);
    }
}

