/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.internal.StreamUtils;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;

public class FilteringCoinSelector
implements CoinSelector {
    protected final CoinSelector delegate;
    protected final Set<TransactionOutPoint> spent;

    public FilteringCoinSelector(CoinSelector delegate, List<TransactionOutPoint> excludedOutPoints) {
        this.delegate = delegate;
        this.spent = Collections.unmodifiableSet(new HashSet<TransactionOutPoint>(excludedOutPoints));
    }

    @Override
    public CoinSelection select(Coin target, List<TransactionOutput> candidates) {
        List<TransactionOutput> filtered = candidates.stream().filter(output -> !this.spent.contains(output.getOutPointFor())).collect(StreamUtils.toUnmodifiableList());
        return this.delegate.select(target, filtered);
    }
}

