/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.util.List;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.UnreadableWalletException;

public interface KeyChainFactory {
    public DeterministicKeyChain makeKeyChain(DeterministicSeed var1, KeyCrypter var2, ScriptType var3, List<ChildNumber> var4);

    @Deprecated
    default public DeterministicKeyChain makeKeyChain(DeterministicSeed seed, KeyCrypter crypter, boolean isMarried, ScriptType outputScriptType, List<ChildNumber> accountPath) {
        Preconditions.check(!isMarried, () -> {
            throw new UnsupportedOperationException("married wallets not supported");
        });
        return this.makeKeyChain(seed, crypter, outputScriptType, accountPath);
    }

    public DeterministicKeyChain makeWatchingKeyChain(DeterministicKey var1, ScriptType var2) throws UnreadableWalletException;

    @Deprecated
    default public DeterministicKeyChain makeWatchingKeyChain(DeterministicKey accountKey, boolean isFollowingKey, boolean isMarried, ScriptType outputScriptType) throws UnreadableWalletException {
        Preconditions.check(!isMarried && !isFollowingKey, () -> {
            throw new UnsupportedOperationException("married wallets not supported");
        });
        return this.makeWatchingKeyChain(accountKey, outputScriptType);
    }

    public DeterministicKeyChain makeSpendingKeyChain(DeterministicKey var1, ScriptType var2) throws UnreadableWalletException;

    @Deprecated
    default public DeterministicKeyChain makeSpendingKeyChain(DeterministicKey accountKey, boolean isMarried, ScriptType outputScriptType) throws UnreadableWalletException {
        Preconditions.check(!isMarried, () -> {
            throw new UnsupportedOperationException("married wallets not supported");
        });
        return this.makeSpendingKeyChain(accountKey, outputScriptType);
    }
}

