/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.LegacyAddress;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.internal.Preconditions;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.AesKey;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.protobuf.wallet.Protos;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.BasicKeyChain;
import org.bitcoinj.wallet.DefaultKeyChainFactory;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.DeterministicUpgradeRequiredException;
import org.bitcoinj.wallet.DeterministicUpgradeRequiresPassword;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.KeyChainGroupStructure;
import org.bitcoinj.wallet.RedeemData;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bitcoinj.wallet.listeners.CurrentKeyChangeEventListener;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyChainGroup
implements KeyBag {
    private static final Logger log = LoggerFactory.getLogger(KeyChainGroup.class);
    private BasicKeyChain basic;
    private final Network network;
    @Nullable
    protected final LinkedList<DeterministicKeyChain> chains;
    private final EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys;
    private final EnumMap<KeyChain.KeyPurpose, Address> currentAddresses;
    @Nullable
    private KeyCrypter keyCrypter;
    private int lookaheadSize = -1;
    private int lookaheadThreshold = -1;
    private final CopyOnWriteArrayList<ListenerRegistration<CurrentKeyChangeEventListener>> currentKeyChangeListeners = new CopyOnWriteArrayList();

    public static KeyChainGroup createBasic(Network network) {
        return new KeyChainGroup(network, new BasicKeyChain(), null, -1, -1, null, null);
    }

    @Deprecated
    public static KeyChainGroup createBasic(NetworkParameters params) {
        return KeyChainGroup.createBasic(params.network());
    }

    public static Builder builder(Network network) {
        return new Builder(network, KeyChainGroupStructure.BIP32);
    }

    @Deprecated
    public static Builder builder(NetworkParameters params) {
        return KeyChainGroup.builder(params.network());
    }

    public static Builder builder(Network network, KeyChainGroupStructure structure) {
        return new Builder(network, structure);
    }

    @Deprecated
    public static Builder builder(NetworkParameters params, KeyChainGroupStructure structure) {
        return KeyChainGroup.builder(params.network(), structure);
    }

    private KeyChainGroup(Network network, @Nullable BasicKeyChain basicKeyChain, @Nullable List<DeterministicKeyChain> chains, int lookaheadSize, int lookaheadThreshold, @Nullable EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys, @Nullable KeyCrypter crypter) {
        this.network = network;
        BasicKeyChain basicKeyChain2 = this.basic = basicKeyChain == null ? new BasicKeyChain() : basicKeyChain;
        if (chains != null) {
            if (lookaheadSize > -1) {
                this.lookaheadSize = lookaheadSize;
            }
            if (lookaheadThreshold > -1) {
                this.lookaheadThreshold = lookaheadThreshold;
            }
            this.chains = new LinkedList<DeterministicKeyChain>(chains);
            for (DeterministicKeyChain chain : this.chains) {
                if (this.lookaheadSize > -1) {
                    chain.setLookaheadSize(this.lookaheadSize);
                }
                if (this.lookaheadThreshold <= -1) continue;
                chain.setLookaheadThreshold(this.lookaheadThreshold);
            }
        } else {
            this.chains = null;
        }
        this.keyCrypter = crypter;
        this.currentKeys = currentKeys == null ? new EnumMap(KeyChain.KeyPurpose.class) : currentKeys;
        this.currentAddresses = new EnumMap(KeyChain.KeyPurpose.class);
    }

    public boolean supportsDeterministicChains() {
        return this.chains != null;
    }

    @Deprecated
    public boolean isSupportsDeterministicChains() {
        return this.supportsDeterministicChains();
    }

    private void maybeLookaheadScripts() {
        for (DeterministicKeyChain chain : this.chains) {
            chain.maybeLookAheadScripts();
        }
    }

    public void addAndActivateHDChain(DeterministicKeyChain chain) {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        log.info("Activating a new HD chain: {}", (Object)chain);
        for (ListenerRegistration<KeyChainEventListener> registration : this.basic.getListeners()) {
            chain.addEventListener((KeyChainEventListener)registration.listener, registration.executor);
        }
        if (this.lookaheadSize >= 0) {
            chain.setLookaheadSize(this.lookaheadSize);
        }
        if (this.lookaheadThreshold >= 0) {
            chain.setLookaheadThreshold(this.lookaheadThreshold);
        }
        this.chains.add(chain);
        this.currentKeys.clear();
        this.currentAddresses.clear();
        this.queueOnCurrentKeyChanged();
    }

    public DeterministicKey currentKey(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        DeterministicKey current = this.currentKeys.get((Object)purpose);
        if (current == null) {
            current = this.freshKey(purpose);
            this.currentKeys.put(purpose, current);
        }
        return current;
    }

    public Address currentAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        ScriptType outputScriptType = chain.getOutputScriptType();
        if (outputScriptType == ScriptType.P2PKH || outputScriptType == ScriptType.P2WPKH) {
            return this.currentKey(purpose).toAddress(outputScriptType, this.network);
        }
        throw new IllegalStateException(chain.getOutputScriptType().toString());
    }

    public DeterministicKey freshKey(KeyChain.KeyPurpose purpose) {
        return this.freshKeys(purpose, 1).get(0);
    }

    public List<DeterministicKey> freshKeys(KeyChain.KeyPurpose purpose, int numberOfKeys) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        return chain.getKeys(purpose, numberOfKeys);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose, ScriptType outputScriptType, @Nullable Instant keyRotationTime) {
        DeterministicKeyChain chain = this.getActiveKeyChain(outputScriptType, keyRotationTime);
        return chain.getKey(purpose).toAddress(outputScriptType, this.network);
    }

    @Deprecated
    public Address freshAddress(KeyChain.KeyPurpose purpose, ScriptType outputScriptType, long keyRotationTimeSecs) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        return this.freshAddress(purpose, outputScriptType, keyRotationTime);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        ScriptType outputScriptType = chain.getOutputScriptType();
        if (outputScriptType == ScriptType.P2PKH || outputScriptType == ScriptType.P2WPKH) {
            return this.freshKey(purpose).toAddress(outputScriptType, this.network);
        }
        throw new IllegalStateException(chain.getOutputScriptType().toString());
    }

    public List<DeterministicKeyChain> getActiveKeyChains(@Nullable Instant keyRotationTime) {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        LinkedList<DeterministicKeyChain> activeChains = new LinkedList<DeterministicKeyChain>();
        for (DeterministicKeyChain chain : this.chains) {
            if (keyRotationTime != null && chain.earliestKeyCreationTime().compareTo(keyRotationTime) < 0) continue;
            activeChains.add(chain);
        }
        return activeChains;
    }

    @Deprecated
    public List<DeterministicKeyChain> getActiveKeyChains(long keyRotationTimeSecs) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        return this.getActiveKeyChains(keyRotationTime);
    }

    public final DeterministicKeyChain getActiveKeyChain(ScriptType outputScriptType, Instant keyRotationTime) {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        ArrayList<DeterministicKeyChain> chainsReversed = new ArrayList<DeterministicKeyChain>(this.chains);
        Collections.reverse(chainsReversed);
        for (DeterministicKeyChain chain : chainsReversed) {
            if (chain.getOutputScriptType() != outputScriptType || keyRotationTime != null && chain.earliestKeyCreationTime().compareTo(keyRotationTime) < 0) continue;
            return chain;
        }
        return null;
    }

    @Deprecated
    public final DeterministicKeyChain getActiveKeyChain(ScriptType outputScriptType, long keyRotationTimeSecs) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        return this.getActiveKeyChain(outputScriptType, keyRotationTime);
    }

    public final DeterministicKeyChain getActiveKeyChain() {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        if (this.chains.isEmpty()) {
            throw new DeterministicUpgradeRequiredException();
        }
        return this.chains.get(this.chains.size() - 1);
    }

    public final void mergeActiveKeyChains(KeyChainGroup from, Instant keyRotationTime) {
        Preconditions.checkArgument(this.isEncrypted() == from.isEncrypted(), () -> "encrypted and non-encrypted keychains cannot be mixed");
        for (DeterministicKeyChain chain : from.getActiveKeyChains(keyRotationTime)) {
            this.addAndActivateHDChain(chain);
        }
    }

    @Deprecated
    public final void mergeActiveKeyChains(KeyChainGroup from, long keyRotationTimeSecs) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        this.mergeActiveKeyChains(from, keyRotationTime);
    }

    public int getLookaheadSize() {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        if (this.lookaheadSize == -1) {
            return this.getActiveKeyChain().getLookaheadSize();
        }
        return this.lookaheadSize;
    }

    public int getLookaheadThreshold() {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        if (this.lookaheadThreshold == -1) {
            return this.getActiveKeyChain().getLookaheadThreshold();
        }
        return this.lookaheadThreshold;
    }

    public int importKeys(List<ECKey> keys2) {
        return this.basic.importKeys(keys2);
    }

    public int importKeys(ECKey ... keys2) {
        return this.importKeys(Collections.unmodifiableList(Arrays.asList(keys2)));
    }

    public boolean checkPassword(CharSequence password) {
        Preconditions.checkState(this.keyCrypter != null, () -> "not encrypted");
        return this.checkAESKey(this.keyCrypter.deriveKey(password));
    }

    public boolean checkAESKey(AesKey aesKey) {
        Preconditions.checkState(this.keyCrypter != null, () -> "not encrypted");
        if (this.basic.numKeys() > 0) {
            return this.basic.checkAESKey(aesKey);
        }
        return this.getActiveKeyChain().checkAESKey(aesKey);
    }

    public int importKeysAndEncrypt(List<ECKey> keys2, AesKey aesKey) {
        Preconditions.checkState(this.keyCrypter != null, () -> "not encrypted");
        LinkedList<ECKey> encryptedKeys = new LinkedList<ECKey>();
        for (ECKey key : keys2) {
            if (key.isEncrypted()) {
                throw new IllegalArgumentException("Cannot provide already encrypted keys");
            }
            encryptedKeys.add(key.encrypt(this.keyCrypter, aesKey));
        }
        return this.importKeys(encryptedKeys);
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
        if (this.chains != null) {
            Iterator<DeterministicKeyChain> iter = this.chains.descendingIterator();
            while (iter.hasNext()) {
                DeterministicKeyChain chain = iter.next();
                RedeemData redeemData = chain.findRedeemDataByScriptHash(ByteString.copyFrom(scriptHash));
                if (redeemData == null) continue;
                return redeemData;
            }
        }
        return null;
    }

    public void markP2SHAddressAsUsed(LegacyAddress address) {
        Preconditions.checkArgument(address.getOutputScriptType() == ScriptType.P2SH);
        RedeemData data = this.findRedeemDataFromScriptHash(address.getHash());
        if (data == null) {
            return;
        }
        for (ECKey key : data.keys) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey k = chain.findKeyFromPubKey(key.getPubKey());
                if (k == null) continue;
                chain.markKeyAsUsed(k);
                this.maybeMarkCurrentAddressAsUsed(address);
            }
        }
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKeyHash(byte[] pubKeyHash, @Nullable ScriptType scriptType) {
        ECKey result = this.basic.findKeyFromPubHash(pubKeyHash);
        if (result != null) {
            return result;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                if (scriptType != null && scriptType != chain.getOutputScriptType() || (result = chain.findKeyFromPubHash(pubKeyHash)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public void markPubKeyHashAsUsed(byte[] pubKeyHash) {
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey key = chain.markPubHashAsUsed(pubKeyHash);
                if (key == null) continue;
                this.maybeMarkCurrentKeyAsUsed(key);
                return;
            }
        }
    }

    private void maybeMarkCurrentAddressAsUsed(LegacyAddress address) {
        Preconditions.checkArgument(address.getOutputScriptType() == ScriptType.P2SH);
        for (Map.Entry<KeyChain.KeyPurpose, Address> entry : this.currentAddresses.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(address)) continue;
            log.info("Marking P2SH address as used: {}", (Object)address);
            this.currentAddresses.put(entry.getKey(), this.freshAddress(entry.getKey()));
            this.queueOnCurrentKeyChanged();
            return;
        }
    }

    private void maybeMarkCurrentKeyAsUsed(DeterministicKey key) {
        for (Map.Entry<KeyChain.KeyPurpose, DeterministicKey> entry : this.currentKeys.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(key)) continue;
            log.info("Marking key as used: {}", (Object)key);
            this.currentKeys.put(entry.getKey(), this.freshKey(entry.getKey()));
            this.queueOnCurrentKeyChanged();
            return;
        }
    }

    public boolean hasKey(ECKey key) {
        if (this.basic.hasKey(key)) {
            return true;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                if (!chain.hasKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubKey) {
        ECKey result = this.basic.findKeyFromPubKey(pubKey);
        if (result != null) {
            return result;
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result = chain.findKeyFromPubKey(pubKey);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void markPubKeyAsUsed(byte[] pubkey) {
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey key = chain.markPubKeyAsUsed(pubkey);
                if (key == null) continue;
                this.maybeMarkCurrentKeyAsUsed(key);
                return;
            }
        }
    }

    public int numKeys() {
        int result = this.basic.numKeys();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result += chain.numKeys();
            }
        }
        return result;
    }

    public boolean removeImportedKey(ECKey key) {
        Objects.requireNonNull(key);
        Preconditions.checkArgument(!(key instanceof DeterministicKey));
        return this.basic.removeKey(key);
    }

    public void encrypt(KeyCrypter keyCrypter, AesKey aesKey) {
        Objects.requireNonNull(keyCrypter);
        Objects.requireNonNull(aesKey);
        Preconditions.checkState(this.chains != null && !this.chains.isEmpty() || this.basic.numKeys() != 0, () -> "can't encrypt entirely empty wallet");
        BasicKeyChain newBasic = this.basic.toEncrypted(keyCrypter, aesKey);
        ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                newChains.add(chain.toEncrypted(keyCrypter, aesKey));
            }
        }
        this.keyCrypter = keyCrypter;
        this.basic = newBasic;
        if (this.chains != null) {
            this.chains.clear();
            this.chains.addAll(newChains);
        }
    }

    public void decrypt(AesKey aesKey) {
        Objects.requireNonNull(aesKey);
        BasicKeyChain newBasic = this.basic.toDecrypted(aesKey);
        if (this.chains != null) {
            ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>(this.chains.size());
            for (DeterministicKeyChain chain : this.chains) {
                newChains.add(chain.toDecrypted(aesKey));
            }
            this.chains.clear();
            this.chains.addAll(newChains);
        }
        this.basic = newBasic;
        this.keyCrypter = null;
    }

    public boolean isEncrypted() {
        return this.keyCrypter != null;
    }

    public boolean isWatching() {
        BasicKeyChain.State basicState = this.basic.isWatching();
        BasicKeyChain.State activeState = BasicKeyChain.State.EMPTY;
        if (this.chains != null && !this.chains.isEmpty()) {
            activeState = this.getActiveKeyChain().isWatching() ? BasicKeyChain.State.WATCHING : BasicKeyChain.State.REGULAR;
        }
        if (basicState == BasicKeyChain.State.EMPTY) {
            if (activeState == BasicKeyChain.State.EMPTY) {
                throw new IllegalStateException("Empty key chain group: cannot answer isWatching() query");
            }
            return activeState == BasicKeyChain.State.WATCHING;
        }
        if (activeState == BasicKeyChain.State.EMPTY) {
            return basicState == BasicKeyChain.State.WATCHING;
        }
        if (activeState != basicState) {
            throw new IllegalStateException("Mix of watching and non-watching keys in wallet");
        }
        return activeState == BasicKeyChain.State.WATCHING;
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        return this.keyCrypter;
    }

    public List<ECKey> getImportedKeys() {
        return this.basic.getKeys();
    }

    public Instant earliestKeyCreationTime() {
        return TimeUtils.earlier(this.basic.earliestKeyCreationTime(), this.getEarliestChainsCreationTime());
    }

    @Deprecated
    public long getEarliestKeyCreationTime() {
        Instant earliestKeyCreationTime = this.earliestKeyCreationTime();
        return earliestKeyCreationTime.equals(Instant.MAX) ? Long.MAX_VALUE : earliestKeyCreationTime.getEpochSecond();
    }

    private Instant getEarliestChainsCreationTime() {
        return this.chains == null ? Instant.MAX : this.chains.stream().map(DeterministicKeyChain::earliestKeyCreationTime).min(Instant::compareTo).orElse(Instant.MAX);
    }

    public int getBloomFilterElementCount() {
        int result = this.basic.numBloomFilterEntries();
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                result += chain.numBloomFilterEntries();
            }
        }
        return result;
    }

    public BloomFilter getBloomFilter(int size, double falsePositiveRate, int nTweak) {
        BloomFilter filter2 = new BloomFilter(size, falsePositiveRate, nTweak);
        if (this.basic.numKeys() > 0) {
            filter2.merge(this.basic.getFilter(size, falsePositiveRate, nTweak));
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                filter2.merge(chain.getFilter(size, falsePositiveRate, nTweak));
            }
        }
        return filter2;
    }

    public boolean isRequiringUpdateAllBloomFilter() {
        throw new UnsupportedOperationException();
    }

    public void addEventListener(KeyChainEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addEventListener(KeyChainEventListener listener, Executor executor) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        this.basic.addEventListener(listener, executor);
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                chain.addEventListener(listener, executor);
            }
        }
    }

    public boolean removeEventListener(KeyChainEventListener listener) {
        Objects.requireNonNull(listener);
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                chain.removeEventListener(listener);
            }
        }
        return this.basic.removeEventListener(listener);
    }

    public void addCurrentKeyChangeEventListener(CurrentKeyChangeEventListener listener) {
        this.addCurrentKeyChangeEventListener(listener, Threading.USER_THREAD);
    }

    public void addCurrentKeyChangeEventListener(CurrentKeyChangeEventListener listener, Executor executor) {
        Objects.requireNonNull(listener);
        this.currentKeyChangeListeners.add(new ListenerRegistration<CurrentKeyChangeEventListener>(listener, executor));
    }

    public boolean removeCurrentKeyChangeEventListener(CurrentKeyChangeEventListener listener) {
        Objects.requireNonNull(listener);
        return ListenerRegistration.removeFromList(listener, this.currentKeyChangeListeners);
    }

    private void queueOnCurrentKeyChanged() {
        for (ListenerRegistration<CurrentKeyChangeEventListener> registration : this.currentKeyChangeListeners) {
            registration.executor.execute(((CurrentKeyChangeEventListener)registration.listener)::onCurrentKeyChanged);
        }
    }

    public List<Protos.Key> serializeToProtobuf() {
        Stream basicStream = this.basic != null ? this.basic.serializeToProtobuf().stream() : Stream.empty();
        Stream chainsStream = this.chains != null ? this.chains.stream().flatMap(chain -> chain.serializeToProtobuf().stream()) : Stream.empty();
        return Stream.concat(basicStream, chainsStream).collect(Collectors.toList());
    }

    static KeyChainGroup fromProtobufUnencrypted(Network network, List<Protos.Key> keys2) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufUnencrypted(network, keys2, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufUnencrypted(Network network, List<Protos.Key> keys2, KeyChainFactory factory2) throws UnreadableWalletException {
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufUnencrypted(keys2);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys2, null, factory2);
        int lookaheadSize = -1;
        int lookaheadThreshold = -1;
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
            lookaheadSize = activeChain.getLookaheadSize();
            lookaheadThreshold = activeChain.getLookaheadThreshold();
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        return new KeyChainGroup(network, basicKeyChain, chains, lookaheadSize, lookaheadThreshold, currentKeys, null);
    }

    static KeyChainGroup fromProtobufEncrypted(Network network, List<Protos.Key> keys2, KeyCrypter crypter) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufEncrypted(network, keys2, crypter, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufEncrypted(Network network, List<Protos.Key> keys2, KeyCrypter crypter, KeyChainFactory factory2) throws UnreadableWalletException {
        Objects.requireNonNull(crypter);
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufEncrypted(keys2, crypter);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys2, crypter, factory2);
        int lookaheadSize = -1;
        int lookaheadThreshold = -1;
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
            lookaheadSize = activeChain.getLookaheadSize();
            lookaheadThreshold = activeChain.getLookaheadThreshold();
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        return new KeyChainGroup(network, basicKeyChain, chains, lookaheadSize, lookaheadThreshold, currentKeys, crypter);
    }

    public void upgradeToDeterministic(ScriptType preferredScriptType, KeyChainGroupStructure structure, @Nullable Instant keyRotationTime, @Nullable AesKey aesKey) throws DeterministicUpgradeRequiresPassword {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        Objects.requireNonNull(structure);
        if (!this.isDeterministicUpgradeRequired(preferredScriptType, keyRotationTime)) {
            return;
        }
        if (preferredScriptType == ScriptType.P2WPKH && this.getActiveKeyChain(ScriptType.P2WPKH, keyRotationTime) == null) {
            DeterministicSeed seed = this.getActiveKeyChain(ScriptType.P2PKH, keyRotationTime).getSeed();
            boolean seedWasEncrypted = seed.isEncrypted();
            if (seedWasEncrypted) {
                if (aesKey == null) {
                    throw new DeterministicUpgradeRequiresPassword();
                }
                seed = seed.decrypt(this.keyCrypter, "", aesKey);
            }
            log.info("Upgrading from P2PKH to P2WPKH deterministic keychain. Using seed: {}", (Object)seed);
            DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(ScriptType.P2WPKH)).accountPath(structure.accountPathFor(ScriptType.P2WPKH, BitcoinNetwork.MAINNET))).build();
            if (seedWasEncrypted) {
                chain = chain.toEncrypted(Objects.requireNonNull(this.keyCrypter), aesKey);
            }
            this.addAndActivateHDChain(chain);
        }
    }

    @Deprecated
    public void upgradeToDeterministic(ScriptType preferredScriptType, KeyChainGroupStructure structure, long keyRotationTimeSecs, @Nullable AesKey aesKey) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        this.upgradeToDeterministic(preferredScriptType, structure, keyRotationTime, aesKey);
    }

    public boolean isDeterministicUpgradeRequired(ScriptType preferredScriptType, @Nullable Instant keyRotationTime) {
        if (!this.supportsDeterministicChains()) {
            return false;
        }
        return this.getActiveKeyChain(preferredScriptType, keyRotationTime) == null;
    }

    @Deprecated
    public boolean isDeterministicUpgradeRequired(ScriptType preferredScriptType, long keyRotationTimeSecs) {
        Instant keyRotationTime = keyRotationTimeSecs > 0L ? Instant.ofEpochSecond(keyRotationTimeSecs) : null;
        return this.isDeterministicUpgradeRequired(preferredScriptType, keyRotationTime);
    }

    private static EnumMap<KeyChain.KeyPurpose, DeterministicKey> createCurrentKeysMap(List<DeterministicKeyChain> chains) {
        DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = new EnumMap<KeyChain.KeyPurpose, DeterministicKey>(KeyChain.KeyPurpose.class);
        if (activeChain.getIssuedExternalKeys() > 0) {
            DeterministicKey currentExternalKey = activeChain.getKeyByPath(activeChain.getAccountPath().extend(DeterministicKeyChain.EXTERNAL_SUBPATH).extend(new ChildNumber(activeChain.getIssuedExternalKeys() - 1), new ChildNumber[0]));
            currentKeys.put(KeyChain.KeyPurpose.RECEIVE_FUNDS, currentExternalKey);
        }
        if (activeChain.getIssuedInternalKeys() > 0) {
            DeterministicKey currentInternalKey = activeChain.getKeyByPath(activeChain.getAccountPath().extend(DeterministicKeyChain.INTERNAL_SUBPATH).extend(new ChildNumber(activeChain.getIssuedInternalKeys() - 1), new ChildNumber[0]));
            currentKeys.put(KeyChain.KeyPurpose.CHANGE, currentInternalKey);
        }
        return currentKeys;
    }

    public String toString(boolean includeLookahead, boolean includePrivateKeys, @Nullable AesKey aesKey) {
        StringBuilder builder = new StringBuilder();
        if (this.basic != null) {
            builder.append(this.basic.toString(includePrivateKeys, aesKey, this.network));
        }
        if (this.chains != null) {
            for (DeterministicKeyChain chain : this.chains) {
                builder.append(chain.toString(includeLookahead, includePrivateKeys, aesKey, this.network)).append('\n');
            }
        }
        return builder.toString();
    }

    public List<DeterministicKeyChain> getDeterministicKeyChains() {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        return new ArrayList<DeterministicKeyChain>(this.chains);
    }

    public int getCombinedKeyLookaheadEpochs() {
        Preconditions.checkState(this.supportsDeterministicChains(), () -> "doesn't support deterministic chains");
        int epoch = 0;
        for (DeterministicKeyChain chain : this.chains) {
            epoch += chain.getKeyLookaheadEpoch();
        }
        return epoch;
    }

    public static class Builder {
        private final Network network;
        private final KeyChainGroupStructure structure;
        private final List<DeterministicKeyChain> chains = new LinkedList<DeterministicKeyChain>();
        private int lookaheadSize = -1;
        private int lookaheadThreshold = -1;

        private Builder(Network network, KeyChainGroupStructure structure) {
            this.network = network;
            this.structure = structure;
        }

        public Builder fromRandom(ScriptType outputScriptType) {
            DeterministicSeed seed = DeterministicSeed.ofRandom(new SecureRandom(), 128, "");
            this.fromSeed(seed, outputScriptType);
            return this;
        }

        public Builder fromSeed(DeterministicSeed seed, ScriptType outputScriptType) {
            if (outputScriptType == ScriptType.P2PKH) {
                DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(ScriptType.P2PKH, this.network))).build();
                this.chains.clear();
                this.chains.add(chain);
            } else if (outputScriptType == ScriptType.P2WPKH) {
                DeterministicKeyChain fallbackChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(ScriptType.P2PKH, this.network))).build();
                DeterministicKeyChain defaultChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(ScriptType.P2WPKH)).accountPath(this.structure.accountPathFor(ScriptType.P2WPKH, this.network))).build();
                this.chains.clear();
                this.chains.add(fallbackChain);
                this.chains.add(defaultChain);
            } else {
                throw new IllegalArgumentException(outputScriptType.toString());
            }
            return this;
        }

        public Builder fromKey(DeterministicKey accountKey, ScriptType outputScriptType) {
            if (outputScriptType == ScriptType.P2PKH) {
                DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(ScriptType.P2PKH, this.network))).build();
                this.chains.clear();
                this.chains.add(chain);
            } else if (outputScriptType == ScriptType.P2WPKH) {
                DeterministicKeyChain fallbackChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(ScriptType.P2PKH)).accountPath(this.structure.accountPathFor(ScriptType.P2PKH, this.network))).build();
                DeterministicKeyChain defaultChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(ScriptType.P2WPKH)).accountPath(this.structure.accountPathFor(ScriptType.P2WPKH, this.network))).build();
                this.chains.clear();
                this.chains.add(fallbackChain);
                this.chains.add(defaultChain);
            } else {
                throw new IllegalArgumentException(outputScriptType.toString());
            }
            return this;
        }

        public Builder addChain(DeterministicKeyChain chain) {
            this.chains.add(chain);
            return this;
        }

        public Builder chains(List<DeterministicKeyChain> chains) {
            this.chains.clear();
            this.chains.addAll(chains);
            return this;
        }

        public Builder lookaheadSize(int lookaheadSize) {
            this.lookaheadSize = lookaheadSize;
            return this;
        }

        public Builder lookaheadThreshold(int lookaheadThreshold) {
            this.lookaheadThreshold = lookaheadThreshold;
            return this;
        }

        public KeyChainGroup build() {
            return new KeyChainGroup(this.network, null, this.chains, this.lookaheadSize, this.lookaheadThreshold, null, null);
        }
    }
}

