/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.HDPath;
import org.bitcoinj.wallet.DeterministicKeyChain;

public interface KeyChainGroupStructure {
    public static final KeyChainGroupStructure BIP32 = (outputScriptType, network) -> {
        if (outputScriptType == null || outputScriptType == ScriptType.P2PKH) {
            return DeterministicKeyChain.ACCOUNT_ZERO_PATH;
        }
        if (outputScriptType == ScriptType.P2WPKH) {
            return DeterministicKeyChain.ACCOUNT_ONE_PATH;
        }
        throw new IllegalArgumentException(outputScriptType.toString());
    };
    public static final KeyChainGroupStructure BIP43 = (outputScriptType, network) -> KeyChainGroupStructure.purpose(outputScriptType).extend(KeyChainGroupStructure.coinType(network), KeyChainGroupStructure.account(0));
    @Deprecated
    public static final KeyChainGroupStructure DEFAULT = BIP32;

    @Deprecated
    default public HDPath accountPathFor(ScriptType outputScriptType) {
        return this.accountPathFor(outputScriptType, BitcoinNetwork.MAINNET);
    }

    public HDPath accountPathFor(ScriptType var1, Network var2);

    @Deprecated
    default public HDPath accountPathFor(ScriptType outputScriptType, NetworkParameters networkParameters) {
        return this.accountPathFor(outputScriptType, networkParameters.network());
    }

    public static HDPath purpose(ScriptType scriptType) {
        if (scriptType == null || scriptType == ScriptType.P2PKH) {
            return HDPath.BIP44_PARENT;
        }
        if (scriptType == ScriptType.P2WPKH) {
            return HDPath.BIP84_PARENT;
        }
        throw new IllegalArgumentException(scriptType.toString());
    }

    public static ChildNumber coinType(Network network) {
        if (!(network instanceof BitcoinNetwork)) {
            throw new IllegalArgumentException("coinType: Unknown network");
        }
        switch ((BitcoinNetwork)network) {
            case MAINNET: {
                return ChildNumber.COINTYPE_BTC;
            }
            case TESTNET: {
                return ChildNumber.COINTYPE_TBTC;
            }
            case REGTEST: {
                return ChildNumber.COINTYPE_TBTC;
            }
        }
        throw new IllegalArgumentException("coinType: Unknown network");
    }

    public static ChildNumber account(int accountIndex) {
        return new ChildNumber(accountIndex, true);
    }
}

