/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.ScriptType;
import org.bitcoinj.base.internal.StreamUtils;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTimeCoinSelector
implements CoinSelector {
    private static final Logger log = LoggerFactory.getLogger(KeyTimeCoinSelector.class);
    public static final int MAX_SIMULTANEOUS_INPUTS = 600;
    private final Instant time;
    private final Wallet wallet;
    private final boolean ignorePending;

    public KeyTimeCoinSelector(Wallet wallet, Instant time, boolean ignorePending) {
        this.time = Objects.requireNonNull(time);
        this.wallet = wallet;
        this.ignorePending = ignorePending;
    }

    @Deprecated
    public KeyTimeCoinSelector(Wallet wallet, long timeSecs, boolean ignorePending) {
        this(wallet, Instant.ofEpochSecond(timeSecs), ignorePending);
    }

    @Override
    public CoinSelection select(Coin target, List<TransactionOutput> candidates) {
        try {
            return candidates.stream().filter(output -> !this.ignorePending || this.isConfirmed((TransactionOutput)output)).filter(this::isKeyBeforeCutoff).limit(600L).collect(Collectors.collectingAndThen(StreamUtils.toUnmodifiableList(), CoinSelection::new));
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isKeyBeforeCutoff(TransactionOutput output) {
        Optional<ECKey> optKey = this.findKey(output);
        return optKey.isPresent() && optKey.get().getCreationTime().orElse(Instant.EPOCH).isBefore(this.time);
    }

    private Optional<ECKey> findKey(TransactionOutput output) {
        ECKey controllingKey;
        Script scriptPubKey = output.getScriptPubKey();
        if (ScriptPattern.isP2PK(scriptPubKey)) {
            controllingKey = this.wallet.findKeyFromPubKey(ScriptPattern.extractKeyFromP2PK(scriptPubKey));
        } else if (ScriptPattern.isP2PKH(scriptPubKey)) {
            controllingKey = this.wallet.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2PKH(scriptPubKey), ScriptType.P2PKH);
        } else if (ScriptPattern.isP2WPKH(scriptPubKey)) {
            controllingKey = this.wallet.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2WH(scriptPubKey), ScriptType.P2WPKH);
        } else {
            log.info("Skipping tx output {} because it's not of simple form.", (Object)output);
            return Optional.empty();
        }
        Objects.requireNonNull(controllingKey, "Coin selector given output as candidate for which we lack the key");
        return Optional.of(controllingKey);
    }

    private boolean isConfirmed(TransactionOutput output) {
        Transaction parent = Objects.requireNonNull(output.getParentTransaction());
        return this.wallet.getConfidence(parent).getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.BUILDING);
    }
}

