/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.bitcoinj.base.Address;
import org.bitcoinj.base.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.crypto.AesKey;
import org.bitcoinj.crypto.ECKey;
import org.bitcoinj.protobuf.payments.Protos;
import org.bitcoinj.utils.ExchangeRate;
import org.bitcoinj.wallet.AllowUnconfirmedCoinSelector;
import org.bitcoinj.wallet.CoinSelector;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.Wallet;

public class SendRequest {
    public final Transaction tx;
    public boolean emptyWallet = false;
    public Address changeAddress = null;
    public Coin feePerKb = Context.get().getFeePerKb();
    public boolean ensureMinRequiredFee = Context.get().isEnsureMinRequiredFee();
    public boolean signInputs = true;
    public AesKey aesKey = null;
    public CoinSelector coinSelector = null;
    public boolean shuffleOutputs = true;
    public Wallet.MissingSigsMode missingSigsMode = Wallet.MissingSigsMode.THROW;
    public ExchangeRate exchangeRate = null;
    public String memo = null;
    public boolean recipientsPayFees = false;
    boolean completed;

    public void setFeePerVkb(Coin feePerVkb) {
        this.feePerKb = feePerVkb;
    }

    public void allowUnconfirmed() {
        this.coinSelector = AllowUnconfirmedCoinSelector.get();
    }

    private SendRequest(Transaction transaction) {
        this.tx = transaction;
    }

    public static SendRequest to(Address destination, Coin value) {
        Transaction tx = new Transaction();
        tx.addOutput(value, destination);
        return new SendRequest(tx);
    }

    public static SendRequest to(ECKey destination, Coin value) {
        Transaction tx = new Transaction();
        tx.addOutput(value, destination);
        return new SendRequest(tx);
    }

    @Deprecated
    public static SendRequest to(NetworkParameters params, ECKey destination, Coin value) {
        return SendRequest.to(destination, value);
    }

    public static SendRequest forTx(Transaction tx) {
        return new SendRequest(tx);
    }

    public static SendRequest emptyWallet(Address destination) {
        Transaction tx = new Transaction();
        tx.addOutput(Coin.ZERO, destination);
        SendRequest req = new SendRequest(tx);
        req.emptyWallet = true;
        return req;
    }

    public static SendRequest childPaysForParent(Wallet wallet, Transaction parentTransaction, Coin feeRaise) {
        TransactionOutput outputToSpend = null;
        for (TransactionOutput output : parentTransaction.getOutputs()) {
            if (!output.isMine(wallet) || !output.isAvailableForSpending() || !output.getValue().isGreaterThan(feeRaise)) continue;
            outputToSpend = output;
            break;
        }
        Objects.requireNonNull(outputToSpend, "Can't find adequately sized output that spends to us");
        Transaction tx = new Transaction();
        tx.addInput(outputToSpend);
        tx.addOutput(outputToSpend.getValue().subtract(feeRaise), wallet.freshAddress(KeyChain.KeyPurpose.CHANGE));
        tx.setPurpose(Transaction.Purpose.RAISE_FEE);
        SendRequest req = SendRequest.forTx(tx);
        req.completed = true;
        return req;
    }

    public SendRequest fromPaymentDetails(Protos.PaymentDetails paymentDetails) {
        if (paymentDetails.hasMemo()) {
            this.memo = paymentDetails.getMemo();
        }
        return this;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues();
        helper.add("emptyWallet", this.emptyWallet);
        helper.add("changeAddress", (Object)this.changeAddress);
        helper.add("feePerKb", (Object)this.feePerKb);
        helper.add("ensureMinRequiredFee", this.ensureMinRequiredFee);
        helper.add("signInputs", this.signInputs);
        helper.add("aesKey", (Object)(this.aesKey != null ? "set" : null));
        helper.add("coinSelector", (Object)this.coinSelector);
        helper.add("shuffleOutputs", this.shuffleOutputs);
        helper.add("recipientsPayFees", this.recipientsPayFees);
        return helper.toString();
    }
}

