/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.bitcoinj.base.internal.Stopwatch;
import org.bitcoinj.base.internal.TimeUtils;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletFiles {
    private static final Logger log = LoggerFactory.getLogger(WalletFiles.class);
    private final Wallet wallet;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ContextPropagatingThreadFactory("Wallet autosave thread", 1));
    private final File file;
    private final AtomicBoolean savePending;
    private final Duration delay;
    private final Callable<Void> saver;
    private volatile Listener vListener;

    public WalletFiles(Wallet wallet, File file, Duration delay) {
        this.executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        this.executor.allowCoreThreadTimeOut(true);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.wallet = Objects.requireNonNull(wallet);
        this.file = Objects.requireNonNull(file);
        this.savePending = new AtomicBoolean();
        this.delay = Objects.requireNonNull(delay);
        this.saver = () -> {
            if (!this.savePending.getAndSet(false)) {
                return null;
            }
            log.info("Background saving wallet; last seen block is height {}, date {}, hash {}", wallet.getLastBlockSeenHeight(), wallet.lastBlockSeenTime().map(time -> TimeUtils.dateTimeFormat(time)).orElse("unknown"), wallet.getLastBlockSeenHash());
            this.saveNowInternal();
            return null;
        };
    }

    @Deprecated
    public WalletFiles(Wallet wallet, File file, long delayTime, TimeUnit timeUnit) {
        this(wallet, file, Duration.ofMillis(timeUnit.toMillis(delayTime)));
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public void setListener(@Nonnull Listener listener) {
        this.vListener = Objects.requireNonNull(listener);
    }

    public void saveNow() throws IOException {
        if (this.executor.isShutdown()) {
            return;
        }
        log.info("Saving wallet; last seen block is height {}, date {}, hash {}", this.wallet.getLastBlockSeenHeight(), this.wallet.lastBlockSeenTime().map(time -> TimeUtils.dateTimeFormat(time)).orElse("unknown"), this.wallet.getLastBlockSeenHash());
        this.saveNowInternal();
    }

    private void saveNowInternal() throws IOException {
        Stopwatch watch = Stopwatch.start();
        File directory = this.file.getAbsoluteFile().getParentFile();
        if (!directory.exists()) {
            throw new FileNotFoundException(directory.getPath() + " (wallet directory not found)");
        }
        File temp = File.createTempFile("wallet", null, directory);
        Listener listener = this.vListener;
        if (listener != null) {
            listener.onBeforeAutoSave(temp);
        }
        this.wallet.saveToFile(temp, this.file);
        if (listener != null) {
            listener.onAfterAutoSave(this.file);
        }
        log.info("Save completed in {}", (Object)watch);
    }

    public void saveLater() {
        if (this.executor.isShutdown() || this.savePending.getAndSet(true)) {
            return;
        }
        this.executor.schedule(this.saver, this.delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void shutdownAndWait() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException x) {
            throw new RuntimeException(x);
        }
    }

    public static interface Listener {
        public void onBeforeAutoSave(File var1);

        public void onAfterAutoSave(File var1);
    }
}

