/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bitcoinj.base.BitcoinNetwork;
import org.bitcoinj.base.Coin;
import org.bitcoinj.base.Network;
import org.bitcoinj.base.Sha256Hash;
import org.bitcoinj.base.utils.Fiat;
import org.bitcoinj.core.LockTime;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.Services;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.params.BitcoinNetworkParams;
import org.bitcoinj.protobuf.wallet.Protos;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.utils.ExchangeRate;
import org.bitcoinj.wallet.DefaultKeyChainFactory;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.KeyChainGroup;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.WalletTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletProtobufSerializer {
    private static final Logger log = LoggerFactory.getLogger(WalletProtobufSerializer.class);
    public static final int CURRENT_WALLET_VERSION = Protos.Wallet.getDefaultInstance().getVersion();
    private static final int WALLET_SIZE_LIMIT = 0x20000000;
    protected Map<ByteString, Transaction> txMap = new HashMap<ByteString, Transaction>();
    private boolean requireMandatoryExtensions = true;
    private boolean requireAllExtensionsKnown = false;
    private int walletWriteBufferSize = 4096;
    private final WalletFactory factory;
    private KeyChainFactory keyChainFactory;

    public WalletProtobufSerializer() {
        this(WalletFactory.DEFAULT);
    }

    public WalletProtobufSerializer(WalletFactory factory2) {
        this.factory = factory2;
        this.keyChainFactory = new DefaultKeyChainFactory();
    }

    public void setKeyChainFactory(KeyChainFactory keyChainFactory) {
        this.keyChainFactory = keyChainFactory;
    }

    public void setRequireMandatoryExtensions(boolean value) {
        this.requireMandatoryExtensions = value;
    }

    public void setRequireAllExtensionsKnown(boolean value) {
        this.requireAllExtensionsKnown = value;
    }

    public void setWalletWriteBufferSize(int walletWriteBufferSize) {
        this.walletWriteBufferSize = walletWriteBufferSize;
    }

    public void writeWallet(Wallet wallet, OutputStream output) throws IOException {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, this.walletWriteBufferSize);
        walletProto.writeTo(codedOutput);
        codedOutput.flush();
    }

    public String walletToText(Wallet wallet) {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        return walletProto.toString();
    }

    public Protos.Wallet walletToProto(Wallet wallet) {
        Protos.Wallet.Builder walletBuilder = Protos.Wallet.newBuilder();
        walletBuilder.setNetworkIdentifier(wallet.network().id());
        if (wallet.getDescription() != null) {
            walletBuilder.setDescription(wallet.getDescription());
        }
        for (WalletTransaction wtx : wallet.getWalletTransactions()) {
            Protos.Transaction txProto = WalletProtobufSerializer.makeTxProto(wtx);
            walletBuilder.addTransaction(txProto);
        }
        walletBuilder.addAllKey(wallet.serializeKeyChainGroupToProtobufInternal());
        for (Script script : wallet.getWatchedScripts()) {
            Protos.Script protoScript = (Protos.Script)Protos.Script.newBuilder().setProgram(ByteString.copyFrom(script.program())).setCreationTimestamp(script.creationTime().orElse(Instant.EPOCH).toEpochMilli()).build();
            walletBuilder.addWatchedScript(protoScript);
        }
        Sha256Hash lastSeenBlockHash = wallet.getLastBlockSeenHash();
        if (lastSeenBlockHash != null) {
            walletBuilder.setLastSeenBlockHash(WalletProtobufSerializer.hashToByteString(lastSeenBlockHash));
            walletBuilder.setLastSeenBlockHeight(wallet.getLastBlockSeenHeight());
        }
        wallet.lastBlockSeenTime().ifPresent(time -> walletBuilder.setLastSeenBlockTimeSecs(time.getEpochSecond()));
        KeyCrypter keyCrypter = wallet.getKeyCrypter();
        if (keyCrypter == null) {
            walletBuilder.setEncryptionType(Protos.Wallet.EncryptionType.UNENCRYPTED);
        } else {
            walletBuilder.setEncryptionType(keyCrypter.getUnderstoodEncryptionType());
            if (keyCrypter instanceof KeyCrypterScrypt) {
                KeyCrypterScrypt keyCrypterScrypt = (KeyCrypterScrypt)keyCrypter;
                walletBuilder.setEncryptionParameters(keyCrypterScrypt.getScryptParameters());
            } else {
                throw new RuntimeException("The wallet has encryption of type '" + keyCrypter.getUnderstoodEncryptionType() + "' but this WalletProtobufSerializer does not know how to persist this.");
            }
        }
        Optional<Instant> keyRotationTime = wallet.keyRotationTime();
        if (keyRotationTime.isPresent()) {
            long timeSecs = keyRotationTime.get().getEpochSecond();
            walletBuilder.setKeyRotationTime(timeSecs);
        }
        WalletProtobufSerializer.populateExtensions(wallet, walletBuilder);
        for (Map.Entry<String, ByteString> entry : wallet.getTags().entrySet()) {
            Protos.Tag.Builder tag = Protos.Tag.newBuilder().setTag(entry.getKey()).setData(entry.getValue());
            walletBuilder.addTags(tag);
        }
        walletBuilder.setVersion(wallet.getVersion());
        return (Protos.Wallet)walletBuilder.build();
    }

    private static void populateExtensions(Wallet wallet, Protos.Wallet.Builder walletBuilder) {
        for (WalletExtension extension : wallet.getExtensions().values()) {
            Protos.Extension.Builder proto = Protos.Extension.newBuilder();
            proto.setId(extension.getWalletExtensionID());
            proto.setMandatory(extension.isWalletExtensionMandatory());
            proto.setData(ByteString.copyFrom(extension.serializeWalletExtension()));
            walletBuilder.addExtension(proto);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Protos.Transaction makeTxProto(WalletTransaction wtx) {
        void var5_19;
        Transaction tx = wtx.getTransaction();
        Protos.Transaction.Builder txBuilder = Protos.Transaction.newBuilder();
        txBuilder.setPool(WalletProtobufSerializer.getProtoPool(wtx)).setHash(WalletProtobufSerializer.hashToByteString(tx.getTxId())).setVersion((int)tx.getVersion());
        tx.updateTime().ifPresent(time -> txBuilder.setUpdatedAt(time.toEpochMilli()));
        LockTime locktime = tx.lockTime();
        if (locktime.isSet()) {
            txBuilder.setLockTime((int)locktime.rawValue());
        }
        for (TransactionInput transactionInput : tx.getInputs()) {
            Protos.TransactionInput.Builder builder = Protos.TransactionInput.newBuilder().setScriptBytes(ByteString.copyFrom(transactionInput.getScriptBytes())).setTransactionOutPointHash(WalletProtobufSerializer.hashToByteString(transactionInput.getOutpoint().hash())).setTransactionOutPointIndex((int)transactionInput.getOutpoint().index());
            if (transactionInput.hasSequence()) {
                builder.setSequence((int)transactionInput.getSequenceNumber());
            }
            if (transactionInput.getValue() != null) {
                builder.setValue(transactionInput.getValue().value);
            }
            if (transactionInput.hasWitness()) {
                TransactionWitness witness = transactionInput.getWitness();
                Protos.ScriptWitness.Builder witnessBuilder = Protos.ScriptWitness.newBuilder();
                int pushCount = witness.getPushCount();
                for (int i2 = 0; i2 < pushCount; ++i2) {
                    witnessBuilder.addData(ByteString.copyFrom(witness.getPush(i2)));
                }
                builder.setWitness(witnessBuilder);
            }
            txBuilder.addTransactionInput(builder);
        }
        for (TransactionOutput transactionOutput : tx.getOutputs()) {
            Protos.TransactionOutput.Builder builder = Protos.TransactionOutput.newBuilder().setScriptBytes(ByteString.copyFrom(transactionOutput.getScriptBytes())).setValue(transactionOutput.getValue().value);
            TransactionInput spentBy = transactionOutput.getSpentBy();
            if (spentBy != null) {
                Sha256Hash spendingHash = spentBy.getParentTransaction().getTxId();
                builder.setSpentByTransactionHash(WalletProtobufSerializer.hashToByteString(spendingHash)).setSpentByTransactionIndex(spentBy.getIndex());
            }
            txBuilder.addTransactionOutput(builder);
        }
        Map<Sha256Hash, Integer> appearsInHashes = tx.getAppearsInHashes();
        if (appearsInHashes != null) {
            for (Map.Entry<Sha256Hash, Integer> entry : appearsInHashes.entrySet()) {
                txBuilder.addBlockHash(WalletProtobufSerializer.hashToByteString(entry.getKey()));
                txBuilder.addBlockRelativityOffsets(entry.getValue());
            }
        }
        if (tx.hasConfidence()) {
            TransactionConfidence transactionConfidence = tx.getConfidence();
            Protos.TransactionConfidence.Builder builder = Protos.TransactionConfidence.newBuilder();
            WalletProtobufSerializer.writeConfidence(txBuilder, transactionConfidence, builder);
        }
        switch (tx.getPurpose()) {
            case UNKNOWN: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.UNKNOWN;
                break;
            }
            case USER_PAYMENT: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.USER_PAYMENT;
                break;
            }
            case KEY_ROTATION: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.KEY_ROTATION;
                break;
            }
            case ASSURANCE_CONTRACT_CLAIM: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_CLAIM;
                break;
            }
            case ASSURANCE_CONTRACT_PLEDGE: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_PLEDGE;
                break;
            }
            case ASSURANCE_CONTRACT_STUB: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.ASSURANCE_CONTRACT_STUB;
                break;
            }
            case RAISE_FEE: {
                Protos.Transaction.Purpose purpose = Protos.Transaction.Purpose.RAISE_FEE;
                break;
            }
            default: {
                throw new RuntimeException("New tx purpose serialization not implemented.");
            }
        }
        txBuilder.setPurpose((Protos.Transaction.Purpose)var5_19);
        ExchangeRate exchangeRate = tx.getExchangeRate();
        if (exchangeRate != null) {
            Protos.ExchangeRate.Builder exchangeRateBuilder = Protos.ExchangeRate.newBuilder().setCoinValue(exchangeRate.coin.value).setFiatValue(exchangeRate.fiat.value).setFiatCurrencyCode(exchangeRate.fiat.currencyCode);
            txBuilder.setExchangeRate(exchangeRateBuilder);
        }
        if (tx.getMemo() != null) {
            txBuilder.setMemo(tx.getMemo());
        }
        return (Protos.Transaction)txBuilder.build();
    }

    private static Protos.Transaction.Pool getProtoPool(WalletTransaction wtx) {
        switch (wtx.getPool()) {
            case UNSPENT: {
                return Protos.Transaction.Pool.UNSPENT;
            }
            case SPENT: {
                return Protos.Transaction.Pool.SPENT;
            }
            case DEAD: {
                return Protos.Transaction.Pool.DEAD;
            }
            case PENDING: {
                return Protos.Transaction.Pool.PENDING;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfidence(Protos.Transaction.Builder txBuilder, TransactionConfidence confidence, Protos.TransactionConfidence.Builder confidenceBuilder) {
        TransactionConfidence transactionConfidence = confidence;
        synchronized (transactionConfidence) {
            confidenceBuilder.setType(Protos.TransactionConfidence.Type.forNumber(confidence.getConfidenceType().getValue()));
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                confidenceBuilder.setAppearedAtHeight(confidence.getAppearedAtChainHeight());
                confidenceBuilder.setDepth(confidence.getDepthInBlocks());
            }
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.DEAD && confidence.getOverridingTxId() != null) {
                Sha256Hash overridingHash = confidence.getOverridingTxId();
                confidenceBuilder.setOverridingTransaction(WalletProtobufSerializer.hashToByteString(overridingHash));
            }
            TransactionConfidence.Source source2 = confidence.getSource();
            switch (source2) {
                case SELF: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_SELF);
                    break;
                }
                case NETWORK: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_NETWORK);
                    break;
                }
                default: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_UNKNOWN);
                }
            }
        }
        for (PeerAddress address : confidence.getBroadcastBy()) {
            Protos.PeerAddress proto = (Protos.PeerAddress)Protos.PeerAddress.newBuilder().setIpAddress(ByteString.copyFrom(address.getAddr().getAddress())).setPort(address.getPort()).setServices(address.getServices().bits()).build();
            confidenceBuilder.addBroadcastBy(proto);
        }
        confidence.getLastBroadcastTime().ifPresent(lastBroadcastTime -> confidenceBuilder.setLastBroadcastedAt(lastBroadcastTime.toEpochMilli()));
        txBuilder.setConfidence(confidenceBuilder);
    }

    public static ByteString hashToByteString(Sha256Hash hash) {
        return ByteString.copyFrom(hash.getBytes());
    }

    public static Sha256Hash byteStringToHash(ByteString bs) {
        return Sha256Hash.wrap(bs.toByteArray());
    }

    public Wallet readWallet(InputStream input, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        return this.readWallet(input, false, walletExtensions);
    }

    public Wallet readWallet(InputStream input, boolean forceReset, @Nullable WalletExtension[] extensions) throws UnreadableWalletException {
        try {
            Protos.Wallet walletProto = WalletProtobufSerializer.parseToProto(input);
            String paramsID = walletProto.getNetworkIdentifier();
            Network network = BitcoinNetwork.fromIdString(paramsID).orElseThrow(() -> new UnreadableWalletException("Unknown network parameters ID " + paramsID));
            return this.readWallet(network, extensions, walletProto, forceReset);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new UnreadableWalletException("Could not parse input stream to protobuf", e);
        }
    }

    public Wallet readWallet(Network network, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto) throws UnreadableWalletException {
        return this.readWallet(network, extensions, walletProto, false);
    }

    @Deprecated
    public Wallet readWallet(NetworkParameters params, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto) throws UnreadableWalletException {
        return this.readWallet(params.network(), extensions, walletProto);
    }

    public Wallet readWallet(Network network, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto, boolean forceReset) throws UnreadableWalletException {
        KeyChainGroup keyChainGroup;
        if (walletProto.getVersion() > CURRENT_WALLET_VERSION) {
            throw new UnreadableWalletException.FutureVersion();
        }
        if (!walletProto.getNetworkIdentifier().equals(network.id())) {
            throw new UnreadableWalletException.WrongNetwork();
        }
        if (walletProto.hasEncryptionParameters()) {
            Protos.ScryptParameters encryptionParameters = walletProto.getEncryptionParameters();
            KeyCrypterScrypt keyCrypter = new KeyCrypterScrypt(encryptionParameters);
            keyChainGroup = KeyChainGroup.fromProtobufEncrypted(network, walletProto.getKeyList(), keyCrypter, this.keyChainFactory);
        } else {
            keyChainGroup = KeyChainGroup.fromProtobufUnencrypted(network, walletProto.getKeyList(), this.keyChainFactory);
        }
        Wallet wallet = this.factory.create(network, keyChainGroup);
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (Protos.Script protoScript : walletProto.getWatchedScriptList()) {
            try {
                long creationTimestamp = protoScript.getCreationTimestamp();
                byte[] programBytes = protoScript.getProgram().toByteArray();
                Script script = creationTimestamp > 0L ? Script.parse(programBytes, Instant.ofEpochMilli(creationTimestamp)) : Script.parse(programBytes);
                scripts.add(script);
            }
            catch (ScriptException e) {
                throw new UnreadableWalletException("Unparseable script in wallet");
            }
        }
        wallet.addWatchedScripts(scripts);
        if (walletProto.hasDescription()) {
            wallet.setDescription(walletProto.getDescription());
        }
        if (forceReset) {
            wallet.setLastBlockSeenHash(null);
            wallet.setLastBlockSeenHeight(-1);
            wallet.clearLastBlockSeenTime();
        } else {
            for (Protos.Transaction txProto : walletProto.getTransactionList()) {
                this.readTransaction(txProto);
            }
            for (Protos.Transaction txProto : walletProto.getTransactionList()) {
                WalletTransaction wtx = this.connectTransactionOutputs(txProto);
                wallet.addWalletTransaction(wtx);
            }
            if (!walletProto.hasLastSeenBlockHash()) {
                wallet.setLastBlockSeenHash(null);
            } else {
                wallet.setLastBlockSeenHash(WalletProtobufSerializer.byteStringToHash(walletProto.getLastSeenBlockHash()));
            }
            if (!walletProto.hasLastSeenBlockHeight()) {
                wallet.setLastBlockSeenHeight(-1);
            } else {
                wallet.setLastBlockSeenHeight(walletProto.getLastSeenBlockHeight());
            }
            wallet.setLastBlockSeenTime(Instant.ofEpochSecond(walletProto.getLastSeenBlockTimeSecs()));
            if (walletProto.hasKeyRotationTime()) {
                wallet.setKeyRotationTime(Instant.ofEpochSecond(walletProto.getKeyRotationTime()));
            }
        }
        this.loadExtensions(wallet, extensions != null ? extensions : new WalletExtension[]{}, walletProto);
        for (Protos.Tag tag : walletProto.getTagsList()) {
            wallet.setTag(tag.getTag(), tag.getData());
        }
        if (walletProto.hasVersion()) {
            wallet.setVersion(walletProto.getVersion());
        }
        this.txMap.clear();
        return wallet;
    }

    @Deprecated
    public Wallet readWallet(NetworkParameters params, @Nullable WalletExtension[] extensions, Protos.Wallet walletProto, boolean forceReset) throws UnreadableWalletException {
        return this.readWallet(params.network(), extensions, walletProto, forceReset);
    }

    private void loadExtensions(Wallet wallet, WalletExtension[] extensionsList, Protos.Wallet walletProto) throws UnreadableWalletException {
        HashMap<String, WalletExtension> extensions = new HashMap<String, WalletExtension>();
        for (WalletExtension e : extensionsList) {
            extensions.put(e.getWalletExtensionID(), e);
        }
        extensions.putAll(wallet.getExtensions());
        for (Protos.Extension extProto : walletProto.getExtensionList()) {
            String id = extProto.getId();
            WalletExtension extension = (WalletExtension)extensions.get(id);
            if (extension == null) {
                if (extProto.getMandatory()) {
                    if (this.requireMandatoryExtensions) {
                        throw new UnreadableWalletException("Unknown mandatory extension in wallet: " + id);
                    }
                    log.error("Unknown extension in wallet {}, ignoring", (Object)id);
                    continue;
                }
                if (!this.requireAllExtensionsKnown) continue;
                throw new UnreadableWalletException("Unknown extension in wallet: " + id);
            }
            log.info("Loading wallet extension {}", (Object)id);
            try {
                wallet.deserializeExtension(extension, extProto.getData().toByteArray());
            }
            catch (Exception e) {
                if (extProto.getMandatory() && this.requireMandatoryExtensions) {
                    log.error("Error whilst reading mandatory extension {}, failing to read wallet", (Object)id);
                    throw new UnreadableWalletException("Could not parse mandatory extension in wallet: " + id);
                }
                if (this.requireAllExtensionsKnown) {
                    log.error("Error whilst reading extension {}, failing to read wallet", (Object)id);
                    throw new UnreadableWalletException("Could not parse extension in wallet: " + id);
                }
                log.warn("Error whilst reading extension {}, ignoring extension", (Object)id, (Object)e);
            }
        }
    }

    public static Protos.Wallet parseToProto(InputStream input) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        codedInput.setSizeLimit(0x20000000);
        return Protos.Wallet.parseFrom(codedInput);
    }

    private void readTransaction(Protos.Transaction txProto) throws UnreadableWalletException {
        Transaction tx;
        block24: {
            block23: {
                tx = new Transaction();
                tx.setVersion(txProto.getVersion());
                if (txProto.hasUpdatedAt()) {
                    long updatedAt = txProto.getUpdatedAt();
                    if (updatedAt > 0L) {
                        tx.setUpdateTime(Instant.ofEpochMilli(updatedAt));
                    } else {
                        tx.clearUpdateTime();
                    }
                }
                for (Protos.TransactionOutput outputProto : txProto.getTransactionOutputList()) {
                    Coin value = Coin.valueOf(outputProto.getValue());
                    byte[] scriptBytes = outputProto.getScriptBytes().toByteArray();
                    TransactionOutput output = new TransactionOutput(tx, value, scriptBytes);
                    tx.addOutput(output);
                }
                for (Protos.TransactionInput inputProto : txProto.getTransactionInputList()) {
                    Protos.ScriptWitness witnessProto;
                    byte[] scriptBytes = inputProto.getScriptBytes().toByteArray();
                    TransactionOutPoint outpoint = new TransactionOutPoint((long)inputProto.getTransactionOutPointIndex() & 0xFFFFFFFFL, WalletProtobufSerializer.byteStringToHash(inputProto.getTransactionOutPointHash()));
                    Coin value = inputProto.hasValue() ? Coin.valueOf(inputProto.getValue()) : null;
                    long sequence2 = inputProto.hasSequence() ? 0xFFFFFFFFL & (long)inputProto.getSequence() : 0xFFFFFFFFL;
                    TransactionWitness witness = null;
                    if (inputProto.hasWitness() && (witnessProto = inputProto.getWitness()).getDataCount() > 0) {
                        ArrayList<byte[]> pushes = new ArrayList<byte[]>(witnessProto.getDataCount());
                        for (int j = 0; j < witnessProto.getDataCount(); ++j) {
                            pushes.add(witnessProto.getData(j).toByteArray());
                        }
                        witness = TransactionWitness.of(pushes);
                    }
                    TransactionInput input = new TransactionInput(tx, scriptBytes, outpoint, sequence2, value, witness);
                    tx.addInput(input);
                }
                for (int i2 = 0; i2 < txProto.getBlockHashCount(); ++i2) {
                    ByteString blockHash = txProto.getBlockHash(i2);
                    int relativityOffset = 0;
                    if (txProto.getBlockRelativityOffsetsCount() > 0) {
                        relativityOffset = txProto.getBlockRelativityOffsets(i2);
                    }
                    tx.addBlockAppearance(WalletProtobufSerializer.byteStringToHash(blockHash), relativityOffset);
                }
                if (txProto.hasLockTime()) {
                    tx.setLockTime(0xFFFFFFFFL & (long)txProto.getLockTime());
                }
                if (!txProto.hasPurpose()) break block23;
                switch (txProto.getPurpose()) {
                    case UNKNOWN: {
                        tx.setPurpose(Transaction.Purpose.UNKNOWN);
                        break block24;
                    }
                    case USER_PAYMENT: {
                        tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
                        break block24;
                    }
                    case KEY_ROTATION: {
                        tx.setPurpose(Transaction.Purpose.KEY_ROTATION);
                        break block24;
                    }
                    case ASSURANCE_CONTRACT_CLAIM: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_CLAIM);
                        break block24;
                    }
                    case ASSURANCE_CONTRACT_PLEDGE: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_PLEDGE);
                        break block24;
                    }
                    case ASSURANCE_CONTRACT_STUB: {
                        tx.setPurpose(Transaction.Purpose.ASSURANCE_CONTRACT_STUB);
                        break block24;
                    }
                    case RAISE_FEE: {
                        tx.setPurpose(Transaction.Purpose.RAISE_FEE);
                        break block24;
                    }
                    default: {
                        throw new RuntimeException("New purpose serialization not implemented");
                    }
                }
            }
            tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
        }
        if (txProto.hasExchangeRate()) {
            Protos.ExchangeRate exchangeRateProto = txProto.getExchangeRate();
            tx.setExchangeRate(new ExchangeRate(Coin.valueOf(exchangeRateProto.getCoinValue()), Fiat.valueOf(exchangeRateProto.getFiatCurrencyCode(), exchangeRateProto.getFiatValue())));
        }
        if (txProto.hasMemo()) {
            tx.setMemo(txProto.getMemo());
        }
        Sha256Hash protoHash = WalletProtobufSerializer.byteStringToHash(txProto.getHash());
        if (!tx.getTxId().equals(protoHash)) {
            throw new UnreadableWalletException(String.format(Locale.US, "Transaction did not deserialize completely: %s vs %s", tx.getTxId(), protoHash));
        }
        if (this.txMap.containsKey(txProto.getHash())) {
            throw new UnreadableWalletException("Wallet contained duplicate transaction " + WalletProtobufSerializer.byteStringToHash(txProto.getHash()));
        }
        this.txMap.put(txProto.getHash(), tx);
    }

    private WalletTransaction connectTransactionOutputs(Protos.Transaction txProto) throws UnreadableWalletException {
        WalletTransaction.Pool pool;
        Transaction tx = this.txMap.get(txProto.getHash());
        switch (txProto.getPool()) {
            case DEAD: {
                pool = WalletTransaction.Pool.DEAD;
                break;
            }
            case PENDING: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            case SPENT: {
                pool = WalletTransaction.Pool.SPENT;
                break;
            }
            case UNSPENT: {
                pool = WalletTransaction.Pool.UNSPENT;
                break;
            }
            case INACTIVE: 
            case PENDING_INACTIVE: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            default: {
                throw new UnreadableWalletException("Unknown transaction pool: " + txProto.getPool());
            }
        }
        for (int i2 = 0; i2 < tx.getOutputs().size(); ++i2) {
            TransactionOutput output = tx.getOutput(i2);
            Protos.TransactionOutput transactionOutput = txProto.getTransactionOutput(i2);
            if (!transactionOutput.hasSpentByTransactionHash()) continue;
            ByteString spentByTransactionHash = transactionOutput.getSpentByTransactionHash();
            Transaction spendingTx = this.txMap.get(spentByTransactionHash);
            if (spendingTx == null) {
                throw new UnreadableWalletException(String.format(Locale.US, "Could not connect %s to %s", tx.getTxId(), WalletProtobufSerializer.byteStringToHash(spentByTransactionHash)));
            }
            int spendingIndex = transactionOutput.getSpentByTransactionIndex();
            TransactionInput input = Objects.requireNonNull(spendingTx.getInput(spendingIndex));
            input.connect(output);
        }
        if (txProto.hasConfidence()) {
            Protos.TransactionConfidence confidenceProto = txProto.getConfidence();
            TransactionConfidence confidence = tx.getConfidence();
            this.readConfidence(tx, confidenceProto, confidence);
        }
        return new WalletTransaction(pool, tx);
    }

    private void readConfidence(Transaction tx, Protos.TransactionConfidence confidenceProto, TransactionConfidence confidence) throws UnreadableWalletException {
        TransactionConfidence.ConfidenceType confidenceType;
        if (!confidenceProto.hasType()) {
            log.warn("Unknown confidence type for tx {}", (Object)tx.getTxId());
            return;
        }
        switch (confidenceProto.getType()) {
            case BUILDING: {
                confidenceType = TransactionConfidence.ConfidenceType.BUILDING;
                break;
            }
            case DEAD: {
                confidenceType = TransactionConfidence.ConfidenceType.DEAD;
                break;
            }
            case NOT_IN_BEST_CHAIN: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            case PENDING: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            case IN_CONFLICT: {
                confidenceType = TransactionConfidence.ConfidenceType.IN_CONFLICT;
                break;
            }
            default: {
                confidenceType = TransactionConfidence.ConfidenceType.UNKNOWN;
            }
        }
        confidence.setConfidenceType(confidenceType);
        if (confidenceProto.hasAppearedAtHeight()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have appearedAtHeight but not BUILDING for tx {}", (Object)tx.getTxId());
                return;
            }
            confidence.setAppearedAtChainHeight(confidenceProto.getAppearedAtHeight());
        }
        if (confidenceProto.hasDepth()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have depth but not BUILDING for tx {}", (Object)tx.getTxId());
                return;
            }
            confidence.setDepthInBlocks(confidenceProto.getDepth());
        }
        if (confidenceProto.hasOverridingTransaction()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.DEAD) {
                log.warn("Have overridingTransaction but not OVERRIDDEN for tx {}", (Object)tx.getTxId());
                return;
            }
            Transaction overridingTransaction = this.txMap.get(confidenceProto.getOverridingTransaction());
            if (overridingTransaction == null) {
                log.warn("Have overridingTransaction that is not in wallet for tx {}", (Object)tx.getTxId());
                return;
            }
            confidence.setOverridingTxId(overridingTransaction.getTxId());
        }
        for (Protos.PeerAddress proto : confidenceProto.getBroadcastByList()) {
            InetAddress ip;
            try {
                ip = InetAddress.getByAddress(proto.getIpAddress().toByteArray());
            }
            catch (UnknownHostException e) {
                throw new UnreadableWalletException("Peer IP address does not have the right length", e);
            }
            int port = proto.getPort();
            Services services = Services.of(proto.getServices());
            PeerAddress address = PeerAddress.inet(ip, port, services, Instant.EPOCH);
            confidence.markBroadcastBy(address);
        }
        if (confidenceProto.hasLastBroadcastedAt()) {
            confidence.setLastBroadcastTime(Instant.ofEpochMilli(confidenceProto.getLastBroadcastedAt()));
        }
        switch (confidenceProto.getSource()) {
            case SOURCE_SELF: {
                confidence.setSource(TransactionConfidence.Source.SELF);
                break;
            }
            case SOURCE_NETWORK: {
                confidence.setSource(TransactionConfidence.Source.NETWORK);
                break;
            }
            default: {
                confidence.setSource(TransactionConfidence.Source.UNKNOWN);
            }
        }
    }

    public static boolean isWallet(InputStream is) {
        try {
            CodedInputStream cis = CodedInputStream.newInstance(is);
            int tag = cis.readTag();
            int field = WireFormat.getTagFieldNumber(tag);
            if (field != 1) {
                return false;
            }
            String network = cis.readString();
            return BitcoinNetworkParams.fromID(network) != null;
        }
        catch (IOException x) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface WalletFactory {
        public static final WalletFactory DEFAULT = Wallet::new;

        public Wallet create(Network var1, KeyChainGroup var2);

        @Deprecated
        default public Wallet create(NetworkParameters params, KeyChainGroup keyChainGroup) {
            return this.create(params.network(), keyChainGroup);
        }
    }
}

