/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.snova;

import org.bouncycastle.pqc.crypto.snova.MapGroup1;
import org.bouncycastle.pqc.crypto.snova.MapGroup2;
import org.bouncycastle.pqc.crypto.snova.SnovaParameters;

class SnovaKeyElements {
    public final MapGroup1 map1;
    public final byte[][][] T12;
    public final MapGroup2 map2;

    public SnovaKeyElements(SnovaParameters snovaParameters) {
        int n = snovaParameters.getO();
        int n2 = snovaParameters.getV();
        int n3 = snovaParameters.getLsq();
        this.map1 = new MapGroup1(snovaParameters);
        this.T12 = new byte[n2][n][n3];
        this.map2 = new MapGroup2(snovaParameters);
    }

    static int copy3d(byte[][][] byArray, byte[] byArray2, int n) {
        for (int j = 0; j < byArray.length; ++j) {
            for (int k = 0; k < byArray[j].length; ++k) {
                System.arraycopy(byArray[j][k], 0, byArray2, n, byArray[j][k].length);
                n += byArray[j][k].length;
            }
        }
        return n;
    }

    static int copy4d(byte[][][][] byArray, byte[] byArray2, int n) {
        for (int j = 0; j < byArray.length; ++j) {
            n = SnovaKeyElements.copy3d(byArray[j], byArray2, n);
        }
        return n;
    }

    static int copy3d(byte[] byArray, int n, byte[][][] byArray2) {
        for (int j = 0; j < byArray2.length; ++j) {
            for (int k = 0; k < byArray2[j].length; ++k) {
                System.arraycopy(byArray, n, byArray2[j][k], 0, byArray2[j][k].length);
                n += byArray2[j][k].length;
            }
        }
        return n;
    }

    static int copy4d(byte[] byArray, int n, byte[][][][] byArray2) {
        for (int j = 0; j < byArray2.length; ++j) {
            for (int k = 0; k < byArray2[j].length; ++k) {
                for (int i2 = 0; i2 < byArray2[j][k].length; ++i2) {
                    System.arraycopy(byArray, n, byArray2[j][k][i2], 0, byArray2[j][k][i2].length);
                    n += byArray2[j][k][i2].length;
                }
            }
        }
        return n;
    }
}

