/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.DefaultCallbackExecutor;
import org.flywaydb.core.internal.callback.NoopCallbackExecutor;
import org.flywaydb.core.internal.callback.SqlScriptCallbackFactory;
import org.flywaydb.core.internal.clazz.NoopClassProvider;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resolver.script.ScriptMigrationResolver;
import org.flywaydb.core.internal.resource.NoopResourceProvider;
import org.flywaydb.core.internal.resource.ResourceNameValidator;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.strategy.RetryStrategy;
import org.flywaydb.core.internal.util.DataUnits;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.Pair;

public class FlywayExecutor {
    private static final Log LOG = LogFactory.getLog(FlywayExecutor.class);
    private final ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private final ResourceNameValidator resourceNameValidator = new ResourceNameValidator();
    private final ResourceNameCache resourceNameCache = new ResourceNameCache();
    private final LocationScannerCache locationScannerCache = new LocationScannerCache();
    private boolean dbConnectionInfoPrinted;
    private final Configuration configuration;

    public FlywayExecutor(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command, boolean scannerRequired, FlywayTelemetryManager flywayTelemetryManager) {
        T result;
        this.configurationValidator.validate(this.configuration);
        StatementInterceptor statementInterceptor = this.configuration.getPluginRegister().getPlugins(StatementInterceptor.class).stream().filter(i2 -> i2.isConfigured(this.configuration)).findFirst().orElse(null);
        Pair<ResourceProvider, ClassProvider<JavaMigration>> resourceProviderClassProviderPair = this.createResourceAndClassProviders(scannerRequired);
        ResourceProvider resourceProvider = resourceProviderClassProviderPair.getLeft();
        ClassProvider<JavaMigration> classProvider = resourceProviderClassProviderPair.getRight();
        ParsingContext parsingContext = new ParsingContext();
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(this.configuration.getDataSource(), this.configuration, statementInterceptor);
        DatabaseType databaseType = jdbcConnectionFactory.getDatabaseType();
        SqlScriptFactory sqlScriptFactory = databaseType.createSqlScriptFactory(this.configuration, parsingContext);
        this.resourceNameValidator.validateSQLMigrationNaming(resourceProvider, this.configuration, databaseType);
        RetryStrategy.setNumberOfRetries(this.configuration.getLockRetryCount());
        SqlScriptExecutorFactory noCallbackSqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, NoopCallbackExecutor.INSTANCE, null);
        jdbcConnectionFactory.setConnectionInitializer((jdbcConnectionFactory1, connection) -> {
            if (this.configuration.getInitSql() == null) {
                return;
            }
            StringResource resource = new StringResource(this.configuration.getInitSql());
            SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, true, resourceProvider);
            boolean outputQueryResults = this.configuration.isOutputQueryResults();
            noCallbackSqlScriptExecutorFactory.createSqlScriptExecutor(connection, false, false, outputQueryResults).execute(sqlScript, this.configuration);
        });
        Database database = null;
        try {
            database = databaseType.createDatabase(this.configuration, jdbcConnectionFactory, statementInterceptor);
            if (!this.dbConnectionInfoPrinted) {
                this.dbConnectionInfoPrinted = true;
                if (database.getDatabaseType() instanceof CommunityDatabaseType) {
                    LOG.info(((CommunityDatabaseType)database.getDatabaseType()).announcementForCommunitySupport());
                }
                LOG.info("Database: " + DatabaseTypeRegister.redactJdbcUrl(jdbcConnectionFactory.getJdbcUrl()) + " (" + jdbcConnectionFactory.getProductName() + ")");
                LOG.debug("Database Type: " + database.getDatabaseType().getName());
                LOG.debug("Driver: " + jdbcConnectionFactory.getDriverInfo());
                if (flywayTelemetryManager != null) {
                    flywayTelemetryManager.notifyDatabaseChanged(database.getDatabaseType().getName(), database.getVersion().toString(), database.getDatabaseHosting());
                }
            }
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Pair<Schema, List<Schema>> schemas = SchemaHistoryFactory.prepareSchemas(this.configuration, database);
            Schema defaultSchema = schemas.getLeft();
            if (statementInterceptor != null) {
                statementInterceptor.init(this.configuration, database, defaultSchema.getTable(this.configuration.getTable()));
            }
            parsingContext.populate(database, this.configuration);
            database.ensureSupported(this.configuration);
            DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, defaultSchema, flywayTelemetryManager, this.prepareCallbacks(database, resourceProvider, jdbcConnectionFactory, sqlScriptFactory, statementInterceptor, defaultSchema, parsingContext, flywayTelemetryManager));
            SqlScriptExecutorFactory sqlScriptExecutorFactory = databaseType.createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            SchemaHistory schemaHistory = SchemaHistoryFactory.getSchemaHistory(this.configuration, noCallbackSqlScriptExecutorFactory, sqlScriptFactory, database, defaultSchema, statementInterceptor);
            result = command.execute(this.createMigrationResolver(resourceProvider, classProvider, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, statementInterceptor), schemaHistory, database, defaultSchema, schemas.getRight().toArray(new Schema[0]), callbackExecutor, statementInterceptor);
        }
        catch (Throwable throwable) {
            IOUtils.close(database);
            if (statementInterceptor instanceof AutoCloseable) {
                IOUtils.close((AutoCloseable)((Object)statementInterceptor));
            }
            this.showMemoryUsage();
            throw throwable;
        }
        IOUtils.close(database);
        if (statementInterceptor instanceof AutoCloseable) {
            IOUtils.close((AutoCloseable)((Object)statementInterceptor));
        }
        this.showMemoryUsage();
        File permit_file = new File(FileUtils.getAppDataFlywayCLILocation(), "permit");
        if (LicenseGuard.getTier(this.configuration) == Tier.COMMUNITY && !permit_file.exists()) {
            LOG.info("");
            LOG.info("You are not signed in to Flyway, to sign in please run auth");
        }
        return result;
    }

    private Pair<ResourceProvider, ClassProvider<JavaMigration>> createResourceAndClassProviders(boolean scannerRequired) {
        ClassProvider classProvider;
        ResourceProvider resourceProvider;
        if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
            resourceProvider = NoopResourceProvider.INSTANCE;
            classProvider = NoopClassProvider.INSTANCE;
        } else if (this.configuration.getResourceProvider() != null && this.configuration.getJavaMigrationClassProvider() != null) {
            resourceProvider = this.configuration.getResourceProvider();
            classProvider = this.configuration.getJavaMigrationClassProvider();
        } else {
            boolean stream = false;
            Scanner<JavaMigration> scanner = new Scanner<JavaMigration>(JavaMigration.class, stream, this.resourceNameCache, this.locationScannerCache, this.configuration);
            resourceProvider = scanner;
            classProvider = scanner;
            if (this.configuration.getResourceProvider() != null) {
                resourceProvider = this.configuration.getResourceProvider();
            }
            if (this.configuration.getJavaMigrationClassProvider() != null) {
                classProvider = this.configuration.getJavaMigrationClassProvider();
            }
        }
        return Pair.of(resourceProvider, classProvider);
    }

    private List<Callback> prepareCallbacks(Database database, ResourceProvider resourceProvider, JdbcConnectionFactory jdbcConnectionFactory, SqlScriptFactory sqlScriptFactory, StatementInterceptor statementInterceptor, Schema schema, ParsingContext parsingContext, FlywayTelemetryManager flywayTelemetryManager) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        NoopCallbackExecutor callbackExecutor = NoopCallbackExecutor.INSTANCE;
        if (statementInterceptor != null) {
            effectiveCallbacks.addAll(statementInterceptor.getCallbacks());
        }
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        LOG.debug("Scanning for script callbacks ...");
        ScriptMigrationResolver scriptMigrationResolver = new ScriptMigrationResolver(resourceProvider, this.configuration, parsingContext, statementInterceptor);
        scriptMigrationResolver.resolveCallbacks();
        effectiveCallbacks.addAll(scriptMigrationResolver.scriptCallbacks);
        if (!this.configuration.isSkipDefaultCallbacks()) {
            SqlScriptExecutorFactory sqlScriptExecutorFactory = jdbcConnectionFactory.getDatabaseType().createSqlScriptExecutorFactory(jdbcConnectionFactory, callbackExecutor, statementInterceptor);
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, this.configuration).getCallbacks());
        }
        if (effectiveCallbacks.stream().anyMatch(x -> x.supports(Event.CREATE_SCHEMA, null))) {
            LOG.warn("'createSchema' callback is deprecated and will be removed in a later release. Please use 'beforeCreateSchema' callback instead.");
        }
        return effectiveCallbacks;
    }

    private CompositeMigrationResolver createMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext, StatementInterceptor statementInterceptor) {
        return new CompositeMigrationResolver(resourceProvider, classProvider, this.configuration, sqlScriptExecutorFactory, sqlScriptFactory, parsingContext, statementInterceptor, this.configuration.getResolvers());
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = DataUnits.MEGABYTE.fromBytes(total);
        long usedMB = DataUnits.MEGABYTE.fromBytes(used);
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    public static interface Command<T> {
        public T execute(CompositeMigrationResolver var1, SchemaHistory var2, Database var3, Schema var4, Schema[] var5, CallbackExecutor var6, StatementInterceptor var7);
    }
}

