/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;

public class CleanExecutor {
    private static final Log LOG = LogFactory.getLog(CleanExecutor.class);
    protected final Connection connection;
    protected final Database database;
    protected final SchemaHistory schemaHistory;
    protected final CallbackExecutor callbackExecutor;

    public CleanExecutor(Connection connection, Database database, SchemaHistory schemaHistory, CallbackExecutor callbackExecutor) {
        this.connection = connection;
        this.database = database;
        this.schemaHistory = schemaHistory;
        this.callbackExecutor = callbackExecutor;
    }

    public void clean(Schema defaultSchema, Schema[] schemas, CleanResult cleanResult) {
        try {
            this.connection.changeCurrentSchemaTo(defaultSchema);
            ArrayList<String> dropSchemas = new ArrayList();
            try {
                dropSchemas = this.schemaHistory.getSchemasCreatedByFlyway();
            }
            catch (Exception e) {
                LOG.error("Error while checking whether the schemas should be dropped. Schemas will not be dropped", e);
            }
            this.clean(schemas, cleanResult, dropSchemas);
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent(Event.AFTER_CLEAN_ERROR);
            throw e;
        }
    }

    protected void clean(Schema[] schemas, CleanResult cleanResult, List<String> dropSchemas) {
        this.dropDatabaseObjectsPreSchemas();
        ArrayList<Schema> schemaList = new ArrayList<Schema>(Arrays.asList(schemas));
        int i2 = 0;
        while (i2 < schemaList.size()) {
            Schema schema = (Schema)schemaList.get(i2);
            if (!schema.exists()) {
                String unknownSchemaWarning = "Unable to clean unknown schema: " + String.valueOf(schema);
                cleanResult.addWarning(unknownSchemaWarning);
                LOG.warn(unknownSchemaWarning);
                schemaList.remove(i2);
                continue;
            }
            ++i2;
        }
        this.cleanSchemas(schemaList.toArray(new Schema[0]), dropSchemas, cleanResult);
        Collections.reverse(schemaList);
        this.cleanSchemas(schemaList.toArray(new Schema[0]), dropSchemas, null);
        this.dropDatabaseObjectsPostSchemas(schemas);
        for (Schema schema : schemas) {
            if (!dropSchemas.contains(schema.getName())) continue;
            this.dropSchema(schema, cleanResult);
        }
    }

    private void dropDatabaseObjectsPreSchemas() {
        LOG.debug("Dropping pre-schema database level objects...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ExecutionTemplateFactory.createExecutionTemplate(this.connection.getJdbcConnection(), this.database).execute(() -> {
                this.database.cleanPreSchemas();
                return null;
            });
            stopWatch.stop();
            LOG.info(String.format("Successfully dropped pre-schema database level objects (execution time %s)", TimeFormat.format(stopWatch.getTotalTimeMillis())));
        }
        catch (FlywaySqlException e) {
            LOG.debug(e.getMessage());
            LOG.warn("Unable to drop pre-schema database level objects");
        }
    }

    private void dropDatabaseObjectsPostSchemas(Schema[] schemas) {
        LOG.debug("Dropping post-schema database level objects...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ExecutionTemplateFactory.createExecutionTemplate(this.connection.getJdbcConnection(), this.database).execute(() -> {
                this.database.cleanPostSchemas(schemas);
                return null;
            });
            stopWatch.stop();
            LOG.info(String.format("Successfully dropped post-schema database level objects (execution time %s)", TimeFormat.format(stopWatch.getTotalTimeMillis())));
        }
        catch (FlywaySqlException e) {
            LOG.debug(e.getMessage());
            LOG.warn("Unable to drop post-schema database level objects");
        }
    }

    private void dropSchema(Schema schema, CleanResult cleanResult) {
        LOG.debug("Dropping schema " + String.valueOf(schema) + "...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ExecutionTemplateFactory.createExecutionTemplate(this.connection.getJdbcConnection(), this.database).execute(() -> {
                schema.drop();
                return null;
            });
            cleanResult.schemasDropped.add(schema.getName());
            stopWatch.stop();
            LOG.info(String.format("Successfully dropped schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
        }
        catch (FlywaySqlException e) {
            LOG.debug(e.getMessage());
            LOG.warn("Unable to drop schema " + String.valueOf(schema) + ". It was cleaned instead.");
            cleanResult.schemasCleaned.add(schema.getName());
        }
    }

    private void cleanSchemas(Schema[] schemas, List<String> dropSchemas, CleanResult cleanResult) {
        for (Schema schema : schemas) {
            if (dropSchemas.contains(schema.getName())) {
                try {
                    this.cleanSchema(schema);
                }
                catch (FlywayException flywayException) {}
                continue;
            }
            this.cleanSchema(schema);
            if (cleanResult == null) continue;
            cleanResult.schemasCleaned.add(schema.getName());
        }
    }

    private void cleanSchema(Schema schema) {
        LOG.debug("Cleaning schema " + String.valueOf(schema) + "...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.doCleanSchema(schema);
        stopWatch.stop();
        LOG.info(String.format("Successfully cleaned schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }

    protected void doCleanSchema(Schema schema) {
        ExecutionTemplateFactory.createExecutionTemplate(this.connection.getJdbcConnection(), this.database).execute(() -> {
            schema.clean();
            return null;
        });
    }
}

