/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.flywaydb.core.internal.configuration.models.FlywayEnvironmentModel;
import org.flywaydb.core.internal.util.MergeUtils;

public class FlywayModel
extends FlywayEnvironmentModel {
    private String environment;
    private String outputType;
    private Boolean outputProgress;
    private String provisionMode;

    public static FlywayModel defaults() {
        FlywayModel model = new FlywayModel();
        model.environment = "default";
        model.setOutputProgress(false);
        model.setReportFilename("report");
        model.setDetectEncoding(false);
        model.setEncoding("UTF-8");
        model.setExecuteInTransaction(true);
        model.setPlaceholderPrefix("${");
        model.setPlaceholderSuffix("}");
        model.setPlaceholderSeparator(":");
        model.setScriptPlaceholderPrefix("FP__");
        model.setScriptPlaceholderSuffix("__");
        model.setSqlMigrationPrefix("V");
        model.setRepeatableSqlMigrationPrefix("R");
        model.setSqlMigrationSeparator("__");
        model.setSqlMigrationSuffixes(Arrays.asList(".sql"));
        model.setCleanDisabled(true);
        model.setCleanOnValidationError(false);
        model.setCommunityDBSupportEnabled(true);
        model.setLocations(new ArrayList<String>(Collections.singletonList("db/migration")));
        model.setJarDirs(new ArrayList<String>());
        model.setTarget("latest");
        model.setTable("flyway_schema_history");
        model.setFailOnMissingTarget(false);
        model.setPlaceholderReplacement(true);
        model.setIgnoreMigrationPatterns(Arrays.asList("*:future"));
        model.setValidateMigrationNaming(false);
        model.setValidateOnMigrate(true);
        model.setBaselineDescription("<< Flyway Baseline >>");
        model.setBaselineOnMigrate(false);
        model.setOutOfOrder(false);
        model.setSkipExecutingMigrations(false);
        model.setCallbacks(new ArrayList<String>());
        model.setSkipDefaultCallbacks(false);
        model.setMigrationResolvers(new ArrayList<String>());
        model.setSkipDefaultResolvers(false);
        model.setMixed(false);
        model.setGroup(false);
        model.setCreateSchemas(true);
        model.setErrorOverrides(new ArrayList<String>());
        model.setStream(false);
        model.setBatch(false);
        model.setOutputQueryResults(true);
        model.setLockRetryCount(50);
        model.setKerberosConfigFile("");
        model.setFailOnMissingLocations(false);
        model.setLoggers(Arrays.asList("auto"));
        model.setPlaceholders(new HashMap<String, String>());
        model.setProvisionMode("provision");
        model.setReportEnabled(false);
        return model;
    }

    public void setEnvironmentProvisionMode(String mode) {
        this.provisionMode = mode;
    }

    public FlywayModel merge(FlywayModel otherPojo) {
        FlywayModel result = new FlywayModel();
        result.environment = MergeUtils.merge(this.environment, otherPojo.environment);
        result.outputProgress = MergeUtils.merge(this.outputProgress, otherPojo.outputProgress);
        result.outputType = MergeUtils.merge(this.outputType, otherPojo.outputType);
        result.provisionMode = MergeUtils.merge(this.provisionMode, otherPojo.provisionMode);
        result.setReportFilename(MergeUtils.merge(this.getReportFilename(), otherPojo.getReportFilename()));
        result.setEncoding(MergeUtils.merge(this.getEncoding(), otherPojo.getEncoding()));
        result.setDetectEncoding(MergeUtils.merge(this.getDetectEncoding(), otherPojo.getDetectEncoding()));
        result.setPlaceholderPrefix(MergeUtils.merge(this.getPlaceholderPrefix(), otherPojo.getPlaceholderPrefix()));
        result.setPlaceholderSuffix(MergeUtils.merge(this.getPlaceholderSuffix(), otherPojo.getPlaceholderSuffix()));
        result.setPlaceholderSeparator(MergeUtils.merge(this.getPlaceholderSeparator(), otherPojo.getPlaceholderSeparator()));
        result.setScriptPlaceholderPrefix(MergeUtils.merge(this.getScriptPlaceholderPrefix(), otherPojo.getScriptPlaceholderPrefix()));
        result.setScriptPlaceholderSuffix(MergeUtils.merge(this.getScriptPlaceholderSuffix(), otherPojo.getScriptPlaceholderSuffix()));
        result.setSqlMigrationPrefix(MergeUtils.merge(this.getSqlMigrationPrefix(), otherPojo.getSqlMigrationPrefix()));
        result.setExecuteInTransaction(MergeUtils.merge(this.getExecuteInTransaction(), otherPojo.getExecuteInTransaction()));
        result.setRepeatableSqlMigrationPrefix(MergeUtils.merge(this.getRepeatableSqlMigrationPrefix(), otherPojo.getRepeatableSqlMigrationPrefix()));
        result.setSqlMigrationSeparator(MergeUtils.merge(this.getSqlMigrationSeparator(), otherPojo.getSqlMigrationSeparator()));
        result.setSqlMigrationSuffixes(MergeUtils.merge(this.getSqlMigrationSuffixes(), otherPojo.getSqlMigrationSuffixes()));
        result.setCleanDisabled(MergeUtils.merge(this.getCleanDisabled(), otherPojo.getCleanDisabled()));
        result.setCleanOnValidationError(MergeUtils.merge(this.getCleanOnValidationError(), otherPojo.getCleanOnValidationError()));
        result.setCommunityDBSupportEnabled(MergeUtils.merge(this.getCommunityDBSupportEnabled(), otherPojo.getCommunityDBSupportEnabled()));
        result.setLocations(MergeUtils.merge(this.getLocations(), otherPojo.getLocations()));
        result.setJarDirs(MergeUtils.merge(this.getJarDirs(), otherPojo.getJarDirs()));
        result.setTable(MergeUtils.merge(this.getTable(), otherPojo.getTable()));
        result.setTablespace(MergeUtils.merge(this.getTablespace(), otherPojo.getTablespace()));
        result.setTarget(MergeUtils.merge(this.getTarget(), otherPojo.getTarget()));
        result.setFailOnMissingTarget(MergeUtils.merge(this.getFailOnMissingTarget(), otherPojo.getFailOnMissingTarget()));
        result.setPlaceholderReplacement(MergeUtils.merge(this.getPlaceholderReplacement(), otherPojo.getPlaceholderReplacement()));
        result.setIgnoreMigrationPatterns(MergeUtils.merge(this.getIgnoreMigrationPatterns(), otherPojo.getIgnoreMigrationPatterns()));
        result.setValidateMigrationNaming(MergeUtils.merge(this.getValidateMigrationNaming(), otherPojo.getValidateMigrationNaming()));
        result.setValidateOnMigrate(MergeUtils.merge(this.getValidateOnMigrate(), otherPojo.getValidateOnMigrate()));
        result.setBaselineVersion(MergeUtils.merge(this.getBaselineVersion(), otherPojo.getBaselineVersion()));
        result.setBaselineDescription(MergeUtils.merge(this.getBaselineDescription(), otherPojo.getBaselineDescription()));
        result.setBaselineOnMigrate(MergeUtils.merge(this.getBaselineOnMigrate(), otherPojo.getBaselineOnMigrate()));
        result.setOutOfOrder(MergeUtils.merge(this.getOutOfOrder(), otherPojo.getOutOfOrder()));
        result.setSkipExecutingMigrations(MergeUtils.merge(this.getSkipExecutingMigrations(), otherPojo.getSkipExecutingMigrations()));
        result.setCallbacks(MergeUtils.merge(this.getCallbacks(), otherPojo.getCallbacks()));
        result.setSkipDefaultCallbacks(MergeUtils.merge(this.getSkipDefaultCallbacks(), otherPojo.getSkipDefaultCallbacks()));
        result.setMigrationResolvers(MergeUtils.merge(this.getMigrationResolvers(), otherPojo.getMigrationResolvers()));
        result.setSkipDefaultResolvers(MergeUtils.merge(this.getSkipDefaultResolvers(), otherPojo.getSkipDefaultResolvers()));
        result.setMixed(MergeUtils.merge(this.getMixed(), otherPojo.getMixed()));
        result.setGroup(MergeUtils.merge(this.getGroup(), otherPojo.getGroup()));
        result.setInstalledBy(MergeUtils.merge(this.getInstalledBy(), otherPojo.getInstalledBy()));
        result.setCreateSchemas(MergeUtils.merge(this.getCreateSchemas(), otherPojo.getCreateSchemas()));
        result.setErrorOverrides(MergeUtils.merge(this.getErrorOverrides(), otherPojo.getErrorOverrides()));
        result.setDryRunOutput(MergeUtils.merge(this.getDryRunOutput(), otherPojo.getDryRunOutput()));
        result.setStream(MergeUtils.merge(this.getStream(), otherPojo.getStream()));
        result.setBatch(MergeUtils.merge(this.getBatch(), otherPojo.getBatch()));
        result.setOutputQueryResults(MergeUtils.merge(this.getOutputQueryResults(), otherPojo.getOutputQueryResults()));
        result.setLockRetryCount(MergeUtils.merge(this.getLockRetryCount(), otherPojo.getLockRetryCount()));
        result.setKerberosConfigFile(MergeUtils.merge(this.getKerberosConfigFile(), otherPojo.getKerberosConfigFile()));
        result.setFailOnMissingLocations(MergeUtils.merge(this.getFailOnMissingLocations(), otherPojo.getFailOnMissingLocations()));
        result.setLoggers(MergeUtils.merge(this.getLoggers(), otherPojo.getLoggers()));
        result.setDefaultSchema(MergeUtils.merge(this.getDefaultSchema(), otherPojo.getDefaultSchema()));
        result.setReportEnabled(MergeUtils.merge(this.getReportEnabled(), otherPojo.getReportEnabled()));
        result.setPlaceholders(MergeUtils.merge(this.getPlaceholders(), otherPojo.getPlaceholders(), (a, b) -> b != null ? b : a));
        result.setPropertyResolvers(MergeUtils.merge(this.getPropertyResolvers(), otherPojo.getPropertyResolvers(), (a, b) -> b != null ? b : a));
        result.setPluginConfigurations(MergeUtils.merge(this.getPluginConfigurations(), otherPojo.getPluginConfigurations(), MergeUtils::mergeObjects));
        return result;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public Boolean getOutputProgress() {
        return this.outputProgress;
    }

    public String getProvisionMode() {
        return this.provisionMode;
    }

    public void setEnvironment(String environment2) {
        this.environment = environment2;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public void setOutputProgress(Boolean outputProgress) {
        this.outputProgress = outputProgress;
    }

    public void setProvisionMode(String provisionMode) {
        this.provisionMode = provisionMode;
    }
}

