/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcNullTypes;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.flywaydb.core.internal.jdbc.WarningImpl;

public class JdbcTemplate {
    protected final Connection connection;
    protected final int nullType;

    public JdbcTemplate(Connection connection, DatabaseType databaseType) {
        this.connection = connection;
        this.nullType = databaseType.getNullType();
    }

    public JdbcTemplate(Connection connection, int nullType) {
        this.connection = connection;
        this.nullType = nullType;
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> queryForList(String query, Object ... params) throws SQLException {
        ArrayList<Map<String, String>> result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = new ArrayList<Map<String, String>>();
            while (resultSet.next()) {
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                for (int i2 = 1; i2 <= resultSet.getMetaData().getColumnCount(); ++i2) {
                    rowMap.put(resultSet.getMetaData().getColumnLabel(i2), resultSet.getString(i2));
                }
                result.add(rowMap);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryForStringList(String query, String ... params) throws SQLException {
        ArrayList<String> result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = new ArrayList<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryForInt(String query, String ... params) throws SQLException {
        int result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            resultSet.next();
            result = resultSet.getInt(1);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long queryForLong(String query, String ... params) throws SQLException {
        long result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            resultSet.next();
            result = resultSet.getLong(1);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryForBoolean(String query, String ... params) throws SQLException {
        boolean result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            resultSet.next();
            result = resultSet.getBoolean(1);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryForString(String query, String ... params) throws SQLException {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(query, params);
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(sql, params);
            statement.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results executeStatement(String sql) {
        Results results = new Results();
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.setEscapeProcessing(false);
            boolean hasResults = statement.execute(sql);
            this.extractResults(results, statement, sql, hasResults);
            this.extractWarnings(results, statement);
        }
        catch (SQLException e) {
            this.extractErrors(results, e);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
        return results;
    }

    protected void extractWarnings(Results results, Statement statement) throws SQLException {
        for (SQLWarning warning = statement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            int code = warning.getErrorCode();
            String state = warning.getSQLState();
            String message = warning.getMessage();
            if (state == null) {
                state = "";
            }
            if (message == null) {
                message = "";
            }
            results.addWarning(new WarningImpl(code, state, message));
        }
    }

    public void extractErrors(Results results, SQLException e) {
        results.setException(e);
    }

    protected void extractResults(Results results, Statement statement, String sql, boolean hasResults) throws SQLException {
        int updateCount = -1;
        while (hasResults || (updateCount = statement.getUpdateCount()) != -1) {
            ArrayList<String> columns = null;
            ArrayList data = null;
            if (hasResults) {
                try (ResultSet resultSet = statement.getResultSet();){
                    columns = new ArrayList<String>();
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    int columnCount = metadata.getColumnCount();
                    for (int i2 = 1; i2 <= columnCount; ++i2) {
                        columns.add(metadata.getColumnName(i2));
                    }
                    data = new ArrayList();
                    while (resultSet.next()) {
                        ArrayList<String> row = new ArrayList<String>();
                        for (int i3 = 1; i3 <= columnCount; ++i3) {
                            row.add(resultSet.getString(i3));
                        }
                        data.add(row);
                    }
                }
            }
            results.addResult(new Result(updateCount, columns, data, sql));
            hasResults = statement.getMoreResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(sql, params);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeStatement(statement);
    }

    protected PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (params[i2] == null) {
                statement.setNull(i2 + 1, this.nullType);
                continue;
            }
            if (params[i2] instanceof Integer) {
                statement.setInt(i2 + 1, (Integer)params[i2]);
                continue;
            }
            if (params[i2] instanceof Boolean) {
                statement.setBoolean(i2 + 1, (Boolean)params[i2]);
                continue;
            }
            if (params[i2] instanceof String) {
                statement.setString(i2 + 1, params[i2].toString());
                continue;
            }
            if (params[i2] == JdbcNullTypes.StringNull) {
                statement.setNull(i2 + 1, this.nullType);
                continue;
            }
            if (params[i2] == JdbcNullTypes.IntegerNull) {
                statement.setNull(i2 + 1, this.nullType);
                continue;
            }
            if (params[i2] == JdbcNullTypes.BooleanNull) {
                statement.setNull(i2 + 1, this.nullType);
                continue;
            }
            throw new FlywayException("Unhandled object of type '" + params[i2].getClass().getName() + "'. Please contact support or leave an issue on GitHub.");
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... params) throws SQLException {
        ArrayList<T> results;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(sql, params);
            resultSet = statement.executeQuery();
            results = new ArrayList<T>();
            while (resultSet.next()) {
                results.add(rowMapper.mapRow(resultSet));
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results executeBatch(List<String> sqlBatch, Configuration config) {
        Results results = new Results();
        Statement statement = null;
        StringBuilder sb = new StringBuilder();
        try {
            statement = this.connection.createStatement();
            for (String sql : sqlBatch) {
                sb.append(sql);
                statement.addBatch(sql);
            }
            try {
                for (Object intResult : (Object)statement.executeBatch()) {
                    results.addResult(new Result((long)intResult, null, null, sb.toString()));
                }
            }
            catch (BatchUpdateException e) {
                for (int intResult : e.getUpdateCounts()) {
                    results.addResult(new Result(intResult, null, null, sb.toString()));
                }
                this.extractErrors(results, e);
            }
            finally {
                this.extractWarnings(results, statement);
            }
        }
        catch (SQLException e) {
            this.extractErrors(results, e);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
        return results;
    }
}

