/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.java.FixedJavaMigrationResolver;
import org.flywaydb.core.internal.resolver.java.ScanningJavaMigrationResolver;
import org.flywaydb.core.internal.resolver.script.ScriptMigrationResolver;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public class CompositeMigrationResolver
implements MigrationResolver {
    private final Collection<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
    private final ResourceProvider resourceProvider;
    private final SqlScriptFactory sqlScriptFactory;
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final StatementInterceptor statementInterceptor;
    private List<ResolvedMigration> availableMigrations;

    public CompositeMigrationResolver(ResourceProvider resourceProvider, ClassProvider<JavaMigration> classProvider, Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, ParsingContext parsingContext, StatementInterceptor statementInterceptor, MigrationResolver ... customMigrationResolvers) {
        this.resourceProvider = resourceProvider;
        this.sqlScriptFactory = sqlScriptFactory;
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.statementInterceptor = statementInterceptor;
        if (!configuration.isSkipDefaultResolvers()) {
            this.migrationResolvers.add(new SqlMigrationResolver(resourceProvider, sqlScriptExecutorFactory, sqlScriptFactory, configuration, parsingContext));
            this.migrationResolvers.add(new ScanningJavaMigrationResolver(classProvider, configuration));
            this.migrationResolvers.addAll(configuration.getPluginRegister().getPlugins(MigrationResolver.class));
            this.migrationResolvers.add(new ScriptMigrationResolver(resourceProvider, configuration, parsingContext, statementInterceptor));
        }
        this.migrationResolvers.add(new FixedJavaMigrationResolver(configuration.getJavaMigrations()));
        this.migrationResolvers.addAll(Arrays.asList(customMigrationResolvers));
    }

    static void checkForIncompatibilities(List<ResolvedMigration> migrations) {
        ResolvedMigrationComparator resolvedMigrationComparator = new ResolvedMigrationComparator();
        for (int i2 = 0; i2 < migrations.size() - 1; ++i2) {
            ResolvedMigration next;
            ResolvedMigration current = migrations.get(i2);
            if (!current.canCompareWith(next = migrations.get(i2 + 1)) || !next.canCompareWith(current) || resolvedMigrationComparator.compare(current, next) != 0) continue;
            if (current.getVersion() != null) {
                throw new FlywayException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s (%s)\n-> %s (%s)", current.getVersion(), current.getPhysicalLocation(), current.getType(), next.getPhysicalLocation(), next.getType()), CoreErrorCode.DUPLICATE_VERSIONED_MIGRATION);
            }
            throw new FlywayException(String.format("Found more than one repeatable migration with description %s\nOffenders:\n-> %s (%s)\n-> %s (%s)", current.getDescription(), current.getPhysicalLocation(), current.getType(), next.getPhysicalLocation(), next.getType()), CoreErrorCode.DUPLICATE_REPEATABLE_MIGRATION);
        }
    }

    @Override
    public Collection<ResolvedMigration> resolveMigrations(MigrationResolver.Context context) {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations(context);
        }
        return this.availableMigrations;
    }

    public Collection<ResolvedMigration> resolveMigrations(Configuration configuration) {
        return this.resolveMigrations(new MigrationResolver.Context(configuration, this.resourceProvider, this.sqlScriptFactory, this.sqlScriptExecutorFactory, this.statementInterceptor));
    }

    private List<ResolvedMigration> doFindAvailableMigrations(MigrationResolver.Context context) throws FlywayException {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>(this.collectMigrations(this.migrationResolvers, context));
        migrations.sort(new ResolvedMigrationComparator());
        CompositeMigrationResolver.checkForIncompatibilities(migrations);
        return migrations;
    }

    Collection<ResolvedMigration> collectMigrations(Collection<MigrationResolver> migrationResolvers, MigrationResolver.Context context) {
        return migrationResolvers.stream().flatMap(mr -> mr.resolveMigrations(context).stream()).collect(Collectors.toSet());
    }
}

