/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.util.StringUtils;

public class AsciiTable {
    private static final String DEFAULT_COLUMN_NAME = "(No column name)";
    private final List<String> columns;
    private final List<List<String>> rows;
    private final boolean printHeader;
    private final String nullText;
    private final String emptyText;

    public AsciiTable(List<String> columns, List<List<String>> rows, boolean printHeader, String nullText, String emptyText) {
        this.columns = AsciiTable.ensureValidColumns(columns);
        this.rows = rows;
        this.printHeader = printHeader;
        this.nullText = nullText;
        this.emptyText = emptyText;
    }

    private static List<String> ensureValidColumns(List<String> columns) {
        ArrayList<String> validColumns = new ArrayList<String>();
        for (String column : columns) {
            validColumns.add(column != null ? column : DEFAULT_COLUMN_NAME);
        }
        return validColumns;
    }

    public String render() {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (String string : this.columns) {
            widths.add(string.length());
        }
        for (List list : this.rows) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                widths.set(i2, Math.max((Integer)widths.get(i2), this.getValue(list, i2).length()));
            }
        }
        StringBuilder ruler = new StringBuilder("+");
        for (Integer width : widths) {
            ruler.append("-").append(StringUtils.trimOrPad("", width, '-')).append("-+");
        }
        ruler.append("\n");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.printHeader) {
            StringBuilder header = new StringBuilder("|");
            for (int i3 = 0; i3 < widths.size(); ++i3) {
                header.append(" ").append(StringUtils.trimOrPad(this.columns.get(i3), (Integer)widths.get(i3), ' ')).append(" |");
            }
            header.append("\n");
            stringBuilder.append((CharSequence)ruler);
            stringBuilder.append((CharSequence)header);
        }
        stringBuilder.append((CharSequence)ruler);
        if (this.rows.isEmpty()) {
            stringBuilder.append("| ").append(StringUtils.trimOrPad(this.emptyText, ruler.length() - Math.min(ruler.length(), 5))).append(" |\n");
        } else {
            for (List<String> row : this.rows) {
                StringBuilder r = new StringBuilder("|");
                for (int i4 = 0; i4 < widths.size(); ++i4) {
                    r.append(" ").append(StringUtils.trimOrPad(this.getValue(row, i4), (Integer)widths.get(i4), ' ')).append(" |");
                }
                r.append("\n");
                stringBuilder.append((CharSequence)r);
            }
        }
        stringBuilder.append((CharSequence)ruler);
        return stringBuilder.toString();
    }

    private String getValue(List<String> row, int i2) {
        String value = row.get(i2);
        if (value == null) {
            value = this.nullText;
        }
        return value;
    }
}

