/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class InitDestroyAnnotationBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
BeanRegistrationAotProcessor,
PriorityOrdered,
Serializable {
    private final transient LifecycleMetadata emptyLifecycleMetadata = new LifecycleMetadata((Class)Object.class, (Collection)Collections.emptyList(), (Collection)Collections.emptyList()){

        @Override
        public void checkInitDestroyMethods(RootBeanDefinition beanDefinition) {
        }

        @Override
        public void invokeInitMethods(Object target, String beanName) {
        }

        @Override
        public void invokeDestroyMethods(Object target, String beanName) {
        }

        @Override
        public boolean hasDestroyMethods() {
            return false;
        }
    };
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final Set<Class<? extends Annotation>> initAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);
    private final Set<Class<? extends Annotation>> destroyAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);
    private int order = Integer.MAX_VALUE;
    @Nullable
    private final transient Map<Class<?>, LifecycleMetadata> lifecycleMetadataCache = new ConcurrentHashMap(256);

    public void setInitAnnotationType(Class<? extends Annotation> initAnnotationType) {
        this.initAnnotationTypes.clear();
        this.initAnnotationTypes.add(initAnnotationType);
    }

    public void addInitAnnotationType(@Nullable Class<? extends Annotation> initAnnotationType) {
        if (initAnnotationType != null) {
            this.initAnnotationTypes.add(initAnnotationType);
        }
    }

    public void setDestroyAnnotationType(Class<? extends Annotation> destroyAnnotationType) {
        this.destroyAnnotationTypes.clear();
        this.destroyAnnotationTypes.add(destroyAnnotationType);
    }

    public void addDestroyAnnotationType(@Nullable Class<? extends Annotation> destroyAnnotationType) {
        if (destroyAnnotationType != null) {
            this.destroyAnnotationTypes.add(destroyAnnotationType);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanClass, String beanName) {
        this.findLifecycleMetadata(beanDefinition, beanClass);
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
        beanDefinition.resolveDestroyMethodIfNecessary();
        LifecycleMetadata metadata = this.findLifecycleMetadata(beanDefinition, registeredBean.getBeanClass());
        if (!CollectionUtils.isEmpty(metadata.initMethods)) {
            String[] initMethodNames = InitDestroyAnnotationBeanPostProcessor.safeMerge(beanDefinition.getInitMethodNames(), metadata.initMethods);
            beanDefinition.setInitMethodNames(initMethodNames);
        }
        if (!CollectionUtils.isEmpty(metadata.destroyMethods)) {
            String[] destroyMethodNames = InitDestroyAnnotationBeanPostProcessor.safeMerge(beanDefinition.getDestroyMethodNames(), metadata.destroyMethods);
            beanDefinition.setDestroyMethodNames(destroyMethodNames);
        }
        return null;
    }

    private LifecycleMetadata findLifecycleMetadata(RootBeanDefinition beanDefinition, Class<?> beanClass) {
        LifecycleMetadata metadata = this.findLifecycleMetadata(beanClass);
        metadata.checkInitDestroyMethods(beanDefinition);
        return metadata;
    }

    private static String[] safeMerge(@Nullable String[] existingNames, Collection<LifecycleMethod> detectedMethods) {
        Stream<String> detectedNames = detectedMethods.stream().map(LifecycleMethod::getIdentifier);
        Stream<String> mergedNames = existingNames != null ? Stream.concat(detectedNames, Stream.of(existingNames)) : detectedNames;
        return (String[])mergedNames.distinct().toArray(String[]::new);
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean2.getClass());
        try {
            metadata.invokeInitMethods(bean2, beanName);
        }
        catch (InvocationTargetException ex) {
            throw new BeanCreationException(beanName, "Invocation of init method failed", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Failed to invoke init method", ex);
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean2, String beanName) throws BeansException {
        block6: {
            LifecycleMetadata metadata = this.findLifecycleMetadata(bean2.getClass());
            try {
                metadata.invokeDestroyMethods(bean2, beanName);
            }
            catch (InvocationTargetException ex) {
                String msg = "Destroy method on bean with name '" + beanName + "' threw an exception";
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, ex.getTargetException());
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn(msg + ": " + String.valueOf(ex.getTargetException()));
                }
            }
            catch (Throwable ex) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("Failed to invoke destroy method on bean with name '" + beanName + "'", ex);
            }
        }
    }

    @Override
    public boolean requiresDestruction(Object bean2) {
        return this.findLifecycleMetadata(bean2.getClass()).hasDestroyMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleMetadata findLifecycleMetadata(Class<?> beanClass) {
        if (this.lifecycleMetadataCache == null) {
            return this.buildLifecycleMetadata(beanClass);
        }
        LifecycleMetadata metadata = this.lifecycleMetadataCache.get(beanClass);
        if (metadata == null) {
            Map<Class<?>, LifecycleMetadata> map = this.lifecycleMetadataCache;
            synchronized (map) {
                metadata = this.lifecycleMetadataCache.get(beanClass);
                if (metadata == null) {
                    metadata = this.buildLifecycleMetadata(beanClass);
                    this.lifecycleMetadataCache.put(beanClass, metadata);
                }
                return metadata;
            }
        }
        return metadata;
    }

    private LifecycleMetadata buildLifecycleMetadata(Class<?> beanClass) {
        if (!AnnotationUtils.isCandidateClass(beanClass, this.initAnnotationTypes) && !AnnotationUtils.isCandidateClass(beanClass, this.destroyAnnotationTypes)) {
            return this.emptyLifecycleMetadata;
        }
        ArrayList<LifecycleMethod> initMethods = new ArrayList<LifecycleMethod>();
        ArrayList<LifecycleMethod> destroyMethods = new ArrayList<LifecycleMethod>();
        Class<?> currentClass = beanClass;
        do {
            ArrayList currInitMethods = new ArrayList();
            ArrayList currDestroyMethods = new ArrayList();
            ReflectionUtils.doWithLocalMethods(currentClass, method -> {
                for (Class<? extends Annotation> initAnnotationType : this.initAnnotationTypes) {
                    if (initAnnotationType == null || !method.isAnnotationPresent(initAnnotationType)) continue;
                    currInitMethods.add(new LifecycleMethod(method, beanClass));
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("Found init method on class [" + beanClass.getName() + "]: " + String.valueOf(method));
                }
                for (Class<? extends Annotation> destroyAnnotationType : this.destroyAnnotationTypes) {
                    if (destroyAnnotationType == null || !method.isAnnotationPresent(destroyAnnotationType)) continue;
                    currDestroyMethods.add(new LifecycleMethod(method, beanClass));
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("Found destroy method on class [" + beanClass.getName() + "]: " + String.valueOf(method));
                }
            });
            initMethods.addAll(0, currInitMethods);
            destroyMethods.addAll(currDestroyMethods);
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass != Object.class);
        return initMethods.isEmpty() && destroyMethods.isEmpty() ? this.emptyLifecycleMetadata : new LifecycleMetadata(beanClass, initMethods, destroyMethods);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
    }

    private class LifecycleMetadata {
        private final Class<?> beanClass;
        private final Collection<LifecycleMethod> initMethods;
        private final Collection<LifecycleMethod> destroyMethods;
        @Nullable
        private volatile Set<LifecycleMethod> checkedInitMethods;
        @Nullable
        private volatile Set<LifecycleMethod> checkedDestroyMethods;

        public LifecycleMetadata(Class<?> beanClass, Collection<LifecycleMethod> initMethods, Collection<LifecycleMethod> destroyMethods) {
            this.beanClass = beanClass;
            this.initMethods = initMethods;
            this.destroyMethods = destroyMethods;
        }

        public void checkInitDestroyMethods(RootBeanDefinition beanDefinition) {
            LinkedHashSet<LifecycleMethod> checkedInitMethods = CollectionUtils.newLinkedHashSet(this.initMethods.size());
            for (LifecycleMethod lifecycleMethod : this.initMethods) {
                String methodIdentifier = lifecycleMethod.getIdentifier();
                if (beanDefinition.isExternallyManagedInitMethod(methodIdentifier)) continue;
                beanDefinition.registerExternallyManagedInitMethod(methodIdentifier);
                checkedInitMethods.add(lifecycleMethod);
                if (!InitDestroyAnnotationBeanPostProcessor.this.logger.isTraceEnabled()) continue;
                InitDestroyAnnotationBeanPostProcessor.this.logger.trace("Registered init method on class [" + this.beanClass.getName() + "]: " + methodIdentifier);
            }
            LinkedHashSet<LifecycleMethod> checkedDestroyMethods = CollectionUtils.newLinkedHashSet(this.destroyMethods.size());
            for (LifecycleMethod lifecycleMethod : this.destroyMethods) {
                String methodIdentifier = lifecycleMethod.getIdentifier();
                if (beanDefinition.isExternallyManagedDestroyMethod(methodIdentifier)) continue;
                beanDefinition.registerExternallyManagedDestroyMethod(methodIdentifier);
                checkedDestroyMethods.add(lifecycleMethod);
                if (!InitDestroyAnnotationBeanPostProcessor.this.logger.isTraceEnabled()) continue;
                InitDestroyAnnotationBeanPostProcessor.this.logger.trace("Registered destroy method on class [" + this.beanClass.getName() + "]: " + methodIdentifier);
            }
            this.checkedInitMethods = checkedInitMethods;
            this.checkedDestroyMethods = checkedDestroyMethods;
        }

        public void invokeInitMethods(Object target, String beanName) throws Throwable {
            Collection<LifecycleMethod> initMethodsToIterate;
            Set<LifecycleMethod> checkedInitMethods = this.checkedInitMethods;
            Collection<LifecycleMethod> collection = initMethodsToIterate = checkedInitMethods != null ? checkedInitMethods : this.initMethods;
            if (!initMethodsToIterate.isEmpty()) {
                for (LifecycleMethod lifecycleMethod : initMethodsToIterate) {
                    if (InitDestroyAnnotationBeanPostProcessor.this.logger.isTraceEnabled()) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.trace("Invoking init method on bean '" + beanName + "': " + String.valueOf(lifecycleMethod.getMethod()));
                    }
                    lifecycleMethod.invoke(target);
                }
            }
        }

        public void invokeDestroyMethods(Object target, String beanName) throws Throwable {
            Collection<LifecycleMethod> destroyMethodsToUse;
            Set<LifecycleMethod> checkedDestroyMethods = this.checkedDestroyMethods;
            Collection<LifecycleMethod> collection = destroyMethodsToUse = checkedDestroyMethods != null ? checkedDestroyMethods : this.destroyMethods;
            if (!destroyMethodsToUse.isEmpty()) {
                for (LifecycleMethod lifecycleMethod : destroyMethodsToUse) {
                    if (InitDestroyAnnotationBeanPostProcessor.this.logger.isTraceEnabled()) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.trace("Invoking destroy method on bean '" + beanName + "': " + String.valueOf(lifecycleMethod.getMethod()));
                    }
                    lifecycleMethod.invoke(target);
                }
            }
        }

        public boolean hasDestroyMethods() {
            Set<LifecycleMethod> checkedDestroyMethods = this.checkedDestroyMethods;
            Collection<LifecycleMethod> destroyMethodsToUse = checkedDestroyMethods != null ? checkedDestroyMethods : this.destroyMethods;
            return !destroyMethodsToUse.isEmpty();
        }
    }

    private static class LifecycleMethod {
        private final Method method;
        private final String identifier;

        public LifecycleMethod(Method method, Class<?> beanClass) {
            if (method.getParameterCount() != 0) {
                throw new IllegalStateException("Lifecycle annotation requires a no-arg method: " + String.valueOf(method));
            }
            this.method = method;
            this.identifier = LifecycleMethod.isPrivateOrNotVisible(method, beanClass) ? ClassUtils.getQualifiedMethodName(method) : method.getName();
        }

        public Method getMethod() {
            return this.method;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void invoke(Object target) throws Throwable {
            ReflectionUtils.makeAccessible(this.method);
            this.method.invoke(target, new Object[0]);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof LifecycleMethod)) return false;
            LifecycleMethod that = (LifecycleMethod)other;
            if (!this.identifier.equals(that.identifier)) return false;
            return true;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        private static boolean isPrivateOrNotVisible(Method method, Class<?> beanClass) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                return true;
            }
            return !method.getDeclaringClass().getPackageName().equals(beanClass.getPackageName()) && !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        }
    }
}

