/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Arrays;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationHook;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.context.aot.ContextAotProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingSupplier;

public class SpringApplicationAotProcessor
extends ContextAotProcessor {
    private final String[] applicationArgs;

    public SpringApplicationAotProcessor(Class<?> application, AbstractAotProcessor.Settings settings, String[] applicationArgs) {
        super(application, settings);
        this.applicationArgs = applicationArgs;
    }

    @Override
    protected GenericApplicationContext prepareApplicationContext(Class<?> application) {
        return new AotProcessorHook(application).run(() -> {
            Method mainMethod = application.getMethod("main", String[].class);
            return ReflectionUtils.invokeMethod(mainMethod, null, new Object[]{this.applicationArgs});
        });
    }

    public static void main(String[] args2) throws Exception {
        int requiredArgs = 6;
        Assert.state(args2.length >= requiredArgs, () -> "Usage: " + SpringApplicationAotProcessor.class.getName() + " <applicationMainClass> <sourceOutput> <resourceOutput> <classOutput> <groupId> <artifactId> <originalArgs...>");
        Class<?> application = Class.forName(args2[0]);
        AbstractAotProcessor.Settings settings = AbstractAotProcessor.Settings.builder().sourceOutput(Paths.get(args2[1], new String[0])).resourceOutput(Paths.get(args2[2], new String[0])).classOutput(Paths.get(args2[3], new String[0])).groupId(StringUtils.hasText(args2[4]) ? args2[4] : "unspecified").artifactId(args2[5]).build();
        String[] applicationArgs = args2.length > requiredArgs ? Arrays.copyOfRange(args2, requiredArgs, args2.length) : new String[]{};
        new SpringApplicationAotProcessor(application, settings, applicationArgs).process();
    }

    private static final class AotProcessorHook
    implements SpringApplicationHook {
        private final Class<?> application;

        private AotProcessorHook(Class<?> application) {
            this.application = application;
        }

        @Override
        public SpringApplicationRunListener getRunListener(SpringApplication application) {
            return new SpringApplicationRunListener(){

                @Override
                public void contextLoaded(ConfigurableApplicationContext context) {
                    throw new SpringApplication.AbandonedRunException(context);
                }
            };
        }

        private <T> GenericApplicationContext run(ThrowingSupplier<T> action) {
            try {
                SpringApplication.withHook((SpringApplicationHook)this, action);
            }
            catch (SpringApplication.AbandonedRunException ex) {
                ConfigurableApplicationContext context = ex.getApplicationContext();
                Assert.state(context instanceof GenericApplicationContext, () -> "AOT processing requires a GenericApplicationContext but got a " + context.getClass().getName());
                return (GenericApplicationContext)context;
            }
            throw new IllegalStateException("No application context available after calling main method of '%s'. Does it run a SpringApplication?".formatted(this.application.getName()));
        }
    }
}

