/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationReplacements;
import org.springframework.boot.autoconfigure.AutoConfigurationSorter;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.core.Ordered;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class AutoConfigurations
extends Configurations
implements Ordered {
    private static final SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();
    private static final int ORDER = 0x7FFFFFFE;
    static final AutoConfigurationReplacements replacements = AutoConfigurationReplacements.load(AutoConfiguration.class, null);
    private final UnaryOperator<String> replacementMapper;

    protected AutoConfigurations(Collection<Class<?>> classes) {
        this(replacements::replace, classes);
    }

    AutoConfigurations(UnaryOperator<String> replacementMapper, Collection<Class<?>> classes) {
        super(AutoConfigurations.sorter(replacementMapper), classes, Class::getName);
        this.replacementMapper = replacementMapper;
    }

    private static UnaryOperator<Collection<Class<?>>> sorter(UnaryOperator<String> replacementMapper) {
        AutoConfigurationSorter sorter = new AutoConfigurationSorter(metadataReaderFactory, null, replacementMapper);
        return classes -> {
            List<String> names = classes.stream().map(Class::getName).map(replacementMapper::apply).toList();
            List<String> sorted2 = sorter.getInPriorityOrder(names);
            return sorted2.stream().map(className -> ClassUtils.resolveClassName(className, null)).collect(Collectors.toCollection(ArrayList::new));
        };
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    protected AutoConfigurations merge(Set<Class<?>> mergedClasses) {
        return new AutoConfigurations(this.replacementMapper, mergedClasses);
    }

    public static AutoConfigurations of(Class<?> ... classes) {
        return new AutoConfigurations(Arrays.asList(classes));
    }
}

