/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import java.time.Duration;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.boot.autoconfigure.amqp.PropertiesRabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.SslBundleRabbitConnectionFactoryBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class RabbitConnectionFactoryBeanConfigurer {
    private final RabbitProperties rabbitProperties;
    private final ResourceLoader resourceLoader;
    private final RabbitConnectionDetails connectionDetails;
    private CredentialsProvider credentialsProvider;
    private CredentialsRefreshService credentialsRefreshService;

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties) {
        this(resourceLoader, properties, new PropertiesRabbitConnectionDetails(properties, null));
    }

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        this(resourceLoader, properties, connectionDetails, null);
    }

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties, RabbitConnectionDetails connectionDetails, SslBundles sslBundles) {
        Assert.notNull((Object)resourceLoader, "'resourceLoader' must not be null");
        Assert.notNull((Object)properties, "'properties' must not be null");
        Assert.notNull((Object)connectionDetails, "'connectionDetails' must not be null");
        this.resourceLoader = resourceLoader;
        this.rabbitProperties = properties;
        this.connectionDetails = connectionDetails;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setCredentialsRefreshService(CredentialsRefreshService credentialsRefreshService) {
        this.credentialsRefreshService = credentialsRefreshService;
    }

    public void configure(RabbitConnectionFactoryBean factory2) {
        Assert.notNull((Object)factory2, "'factory' must not be null");
        factory2.setResourceLoader(this.resourceLoader);
        RabbitConnectionDetails.Address address = this.connectionDetails.getFirstAddress();
        PropertyMapper map = PropertyMapper.get();
        map.from(address::host).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setHost(arg_0));
        map.from(address::port).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setPort(arg_0));
        map.from(this.connectionDetails::getUsername).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setUsername(arg_0));
        map.from(this.connectionDetails::getPassword).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setPassword(arg_0));
        map.from(this.connectionDetails::getVirtualHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setVirtualHost(arg_0));
        map.from(this.rabbitProperties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setRequestedHeartbeat(arg_0));
        map.from(this.rabbitProperties::getRequestedChannelMax).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setRequestedChannelMax(arg_0));
        SslBundle sslBundle = this.connectionDetails.getSslBundle();
        if (sslBundle != null) {
            RabbitConnectionFactoryBeanConfigurer.applySslBundle(factory2, sslBundle);
        } else {
            RabbitProperties.Ssl ssl = this.rabbitProperties.getSsl();
            if (ssl.determineEnabled()) {
                factory2.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setSslAlgorithm(arg_0));
                map.from(ssl::getKeyStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStoreType(arg_0));
                map.from(ssl::getKeyStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStore(arg_0));
                map.from(ssl::getKeyStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStorePassphrase(arg_0));
                map.from(ssl::getKeyStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setKeyStoreAlgorithm(arg_0));
                map.from(ssl::getTrustStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStoreType(arg_0));
                map.from(ssl::getTrustStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStore(arg_0));
                map.from(ssl::getTrustStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStorePassphrase(arg_0));
                map.from(ssl::getTrustStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setTrustStoreAlgorithm(arg_0));
                map.from(ssl::isValidateServerCertificate).to(validate -> factory2.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::isVerifyHostname).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setEnableHostnameVerification(arg_0));
            }
        }
        map.from(this.rabbitProperties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setConnectionTimeout(arg_0));
        map.from(this.rabbitProperties::getChannelRpcTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setChannelRpcTimeout(arg_0));
        map.from(this.credentialsProvider).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setCredentialsProvider(arg_0));
        map.from(this.credentialsRefreshService).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setCredentialsRefreshService(arg_0));
        map.from(this.rabbitProperties.getMaxInboundMessageBodySize()).whenNonNull().asInt(DataSize::toBytes).to(arg_0 -> ((RabbitConnectionFactoryBean)factory2).setMaxInboundMessageBodySize(arg_0));
    }

    private static void applySslBundle(RabbitConnectionFactoryBean factory2, SslBundle bundle2) {
        factory2.setUseSSL(true);
        if (factory2 instanceof SslBundleRabbitConnectionFactoryBean) {
            SslBundleRabbitConnectionFactoryBean sslFactory = (SslBundleRabbitConnectionFactoryBean)factory2;
            sslFactory.setSslBundle(bundle2);
        }
    }
}

