/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http2.Http2Protocol;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class TomcatWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;

    public TomcatWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableTomcatWebServerFactory factory2) {
        ServerProperties.Tomcat properties = this.serverProperties.getTomcat();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getBasedir).to(factory2::setBaseDirectory);
        map.from(properties::getBackgroundProcessorDelay).as(Duration::getSeconds).as(Long::intValue).to(factory2::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory2);
        ServerProperties.Tomcat.Threads threadProperties = properties.getThreads();
        map.from(threadProperties::getMax).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory2, (int)maxThreads));
        map.from(threadProperties::getMinSpare).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory2, (int)minSpareThreads));
        map.from(threadProperties::getMaxQueueCapacity).when(this::isPositive).to(maxQueueCapacity -> this.customizeMaxQueueCapacity(factory2, (int)maxQueueCapacity));
        map.from(this.serverProperties.getMaxHttpRequestHeaderSize()).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpRequestHeaderSize -> this.customizeMaxHttpRequestHeaderSize(factory2, (int)maxHttpRequestHeaderSize));
        map.from(properties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpResponseHeaderSize -> this.customizeMaxHttpResponseHeaderSize(factory2, (int)maxHttpResponseHeaderSize));
        map.from(properties::getMaxSwallowSize).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory2, (int)maxSwallowSize));
        map.from(properties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(maxHttpFormPostSize -> maxHttpFormPostSize != 0).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory2, (int)maxHttpFormPostSize));
        map.from(properties::getMaxParameterCount).to(maxParameterCount -> this.customizeMaxParameterCount(factory2, (int)maxParameterCount));
        map.from(properties::getMaxPartHeaderSize).asInt(DataSize::toBytes).to(maxPartHeaderSize -> this.customizeMaxPartHeaderSize(factory2, (int)maxPartHeaderSize));
        map.from(properties::getMaxPartCount).to(maxPartCount -> this.customizeMaxPartCount(factory2, (int)maxPartCount));
        map.from(properties::getAccesslog).when(ServerProperties.Tomcat.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory2));
        map.from(properties::getUriEncoding).to(factory2::setUriEncoding);
        map.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory2, (Duration)connectionTimeout));
        map.from(properties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory2, (int)maxConnections));
        map.from(properties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory2, (int)acceptCount));
        map.from(properties::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory2, (int)processorCache));
        map.from(properties::getKeepAliveTimeout).to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory2, (Duration)keepAliveTimeout));
        map.from(properties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory2, (int)maxKeepAliveRequests));
        map.from(properties::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory2, (String)relaxedChars));
        map.from(properties::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory2, (String)relaxedChars));
        this.customizeStaticResources(factory2);
        this.customizeErrorReportValve(this.serverProperties.getError(), factory2);
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private void customizeMaxThreads(ConfigurableTomcatWebServerFactory factory2, int maxThreads) {
        this.customizeHandler(factory2, maxThreads, AbstractProtocol.class, AbstractProtocol::setMaxThreads);
    }

    private void customizeMinThreads(ConfigurableTomcatWebServerFactory factory2, int minSpareThreads) {
        this.customizeHandler(factory2, minSpareThreads, AbstractProtocol.class, AbstractProtocol::setMinSpareThreads);
    }

    private void customizeMaxQueueCapacity(ConfigurableTomcatWebServerFactory factory2, int maxQueueCapacity) {
        this.customizeHandler(factory2, maxQueueCapacity, AbstractProtocol.class, AbstractProtocol::setMaxQueueSize);
    }

    private void customizeAcceptCount(ConfigurableTomcatWebServerFactory factory2, int acceptCount) {
        this.customizeHandler(factory2, acceptCount, AbstractProtocol.class, AbstractProtocol::setAcceptCount);
    }

    private void customizeProcessorCache(ConfigurableTomcatWebServerFactory factory2, int processorCache) {
        this.customizeHandler(factory2, processorCache, AbstractProtocol.class, AbstractProtocol::setProcessorCache);
    }

    private void customizeKeepAliveTimeout(ConfigurableTomcatWebServerFactory factory2, Duration keepAliveTimeout) {
        factory2.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                Http2Protocol protocol = (Http2Protocol)upgradeProtocol;
                protocol.setKeepAliveTimeout(keepAliveTimeout.toMillis());
            }
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        });
    }

    private void customizeMaxKeepAliveRequests(ConfigurableTomcatWebServerFactory factory2, int maxKeepAliveRequests) {
        this.customizeHandler(factory2, maxKeepAliveRequests, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxKeepAliveRequests);
    }

    private void customizeMaxConnections(ConfigurableTomcatWebServerFactory factory2, int maxConnections) {
        this.customizeHandler(factory2, maxConnections, AbstractProtocol.class, AbstractProtocol::setMaxConnections);
    }

    private void customizeConnectionTimeout(ConfigurableTomcatWebServerFactory factory2, Duration connectionTimeout) {
        this.customizeHandler(factory2, (int)connectionTimeout.toMillis(), AbstractProtocol.class, AbstractProtocol::setConnectionTimeout);
    }

    private void customizeRelaxedPathChars(ConfigurableTomcatWebServerFactory factory2, String relaxedChars) {
        factory2.addConnectorCustomizers(connector -> connector.setProperty("relaxedPathChars", relaxedChars));
    }

    private void customizeRelaxedQueryChars(ConfigurableTomcatWebServerFactory factory2, String relaxedChars) {
        factory2.addConnectorCustomizers(connector -> connector.setProperty("relaxedQueryChars", relaxedChars));
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private void customizeRemoteIpValve(ConfigurableTomcatWebServerFactory factory2) {
        ServerProperties.Tomcat.Remoteip remoteIpProperties = this.serverProperties.getTomcat().getRemoteip();
        String protocolHeader = remoteIpProperties.getProtocolHeader();
        String remoteIpHeader = remoteIpProperties.getRemoteIpHeader();
        if (StringUtils.hasText(protocolHeader) || StringUtils.hasText(remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength(protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength(remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setTrustedProxies(remoteIpProperties.getTrustedProxies());
            valve.setInternalProxies(remoteIpProperties.getInternalProxies());
            try {
                valve.setHostHeader(remoteIpProperties.getHostHeader());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            valve.setPortHeader(remoteIpProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(remoteIpProperties.getProtocolHeaderHttpsValue());
            factory2.addEngineValves(valve);
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy() == ServerProperties.ForwardHeadersStrategy.NATIVE;
    }

    private void customizeMaxHttpRequestHeaderSize(ConfigurableTomcatWebServerFactory factory2, int maxHttpRequestHeaderSize) {
        this.customizeHandler(factory2, maxHttpRequestHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpRequestHeaderSize);
    }

    private void customizeMaxHttpResponseHeaderSize(ConfigurableTomcatWebServerFactory factory2, int maxHttpResponseHeaderSize) {
        this.customizeHandler(factory2, maxHttpResponseHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpResponseHeaderSize);
    }

    private void customizeMaxSwallowSize(ConfigurableTomcatWebServerFactory factory2, int maxSwallowSize) {
        this.customizeHandler(factory2, maxSwallowSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxSwallowSize);
    }

    private <T extends ProtocolHandler> void customizeHandler(ConfigurableTomcatWebServerFactory factory2, int value, Class<T> type, ObjIntConsumer<T> consumer) {
        factory2.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (type.isAssignableFrom(handler.getClass())) {
                consumer.accept((ProtocolHandler)type.cast(handler), value);
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableTomcatWebServerFactory factory2, int maxHttpFormPostSize) {
        factory2.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpFormPostSize));
    }

    private void customizeMaxParameterCount(ConfigurableTomcatWebServerFactory factory2, int maxParameterCount) {
        factory2.addConnectorCustomizers(connector -> connector.setMaxParameterCount(maxParameterCount));
    }

    private void customizeMaxPartCount(ConfigurableTomcatWebServerFactory factory2, int maxPartCount) {
        factory2.addConnectorCustomizers(connector -> {
            try {
                connector.setMaxPartCount(maxPartCount);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        });
    }

    private void customizeMaxPartHeaderSize(ConfigurableTomcatWebServerFactory factory2, int maxPartHeaderSize) {
        factory2.addConnectorCustomizers(connector -> {
            try {
                connector.setMaxPartHeaderSize(maxPartHeaderSize);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        });
    }

    private void customizeAccessLog(ConfigurableTomcatWebServerFactory factory2) {
        ServerProperties.Tomcat tomcatProperties = this.serverProperties.getTomcat();
        AccessLogValve valve = new AccessLogValve();
        PropertyMapper map = PropertyMapper.get();
        ServerProperties.Tomcat.Accesslog accessLogConfig = tomcatProperties.getAccesslog();
        map.from(accessLogConfig.getConditionIf()).to(valve::setConditionIf);
        map.from(accessLogConfig.getConditionUnless()).to(valve::setConditionUnless);
        map.from(accessLogConfig.getPattern()).to(valve::setPattern);
        map.from(accessLogConfig.getDirectory()).to(valve::setDirectory);
        map.from(accessLogConfig.getPrefix()).to(valve::setPrefix);
        map.from(accessLogConfig.getSuffix()).to(valve::setSuffix);
        map.from(accessLogConfig.getEncoding()).whenHasText().to(valve::setEncoding);
        map.from(accessLogConfig.getLocale()).whenHasText().to(valve::setLocale);
        map.from(accessLogConfig.isCheckExists()).to(valve::setCheckExists);
        map.from(accessLogConfig.isRotate()).to(valve::setRotatable);
        map.from(accessLogConfig.isRenameOnRotate()).to(valve::setRenameOnRotate);
        map.from(accessLogConfig.getMaxDays()).to(valve::setMaxDays);
        map.from(accessLogConfig.getFileDateFormat()).to(valve::setFileDateFormat);
        map.from(accessLogConfig.isIpv6Canonical()).to(valve::setIpv6Canonical);
        map.from(accessLogConfig.isRequestAttributesEnabled()).to(valve::setRequestAttributesEnabled);
        map.from(accessLogConfig.isBuffered()).to(valve::setBuffered);
        factory2.addEngineValves(valve);
    }

    private void customizeStaticResources(ConfigurableTomcatWebServerFactory factory2) {
        ServerProperties.Tomcat.Resource resource = this.serverProperties.getTomcat().getResource();
        factory2.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableTomcatWebServerFactory factory2) {
        if (error.getIncludeStacktrace() == ErrorProperties.IncludeAttribute.NEVER) {
            factory2.addContextCustomizers(context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve(valve);
            });
        }
    }
}

