/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientSsl;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.web.reactive.function.client.WebClient;

class AutoConfiguredWebClientSsl
implements WebClientSsl {
    private final ClientHttpConnectorBuilder<?> connectorBuilder;
    private final ClientHttpConnectorSettings settings;
    private final SslBundles sslBundles;

    AutoConfiguredWebClientSsl(ClientHttpConnectorBuilder<?> connectorBuilder, ClientHttpConnectorSettings settings, SslBundles sslBundles) {
        this.connectorBuilder = connectorBuilder;
        this.settings = settings;
        this.sslBundles = sslBundles;
    }

    @Override
    public Consumer<WebClient.Builder> fromBundle(String bundleName) {
        return this.fromBundle(this.sslBundles.getBundle(bundleName));
    }

    @Override
    public Consumer<WebClient.Builder> fromBundle(SslBundle bundle2) {
        return builder -> {
            ClientHttpConnectorSettings settings = this.settings.withSslBundle(bundle2);
            Object connector = this.connectorBuilder.build(settings);
            builder.clientConnector(connector);
        };
    }
}

