/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.DefaultPropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.SpringIterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.SystemEnvironmentPropertyMapper;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;

class SpringConfigurationPropertySource
implements ConfigurationPropertySource {
    private static final PropertyMapper[] DEFAULT_MAPPERS = new PropertyMapper[]{DefaultPropertyMapper.INSTANCE};
    private static final PropertyMapper[] SYSTEM_ENVIRONMENT_MAPPERS = new PropertyMapper[]{SystemEnvironmentPropertyMapper.INSTANCE, DefaultPropertyMapper.INSTANCE};
    private final PropertySource<?> propertySource;
    private final boolean systemEnvironmentSource;
    private final PropertyMapper[] mappers;

    SpringConfigurationPropertySource(PropertySource<?> propertySource, boolean systemEnvironmentSource, PropertyMapper ... mappers) {
        Assert.notNull(propertySource, "'propertySource' must not be null");
        Assert.isTrue(mappers.length > 0, "'mappers' must contain at least one item");
        this.propertySource = propertySource;
        this.systemEnvironmentSource = systemEnvironmentSource;
        this.mappers = mappers;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
        if (name == null) {
            return null;
        }
        for (PropertyMapper mapper : this.mappers) {
            try {
                for (String candidate : mapper.map(name)) {
                    Object value = this.getPropertySourceProperty(candidate);
                    if (value == null) continue;
                    Origin origin = PropertySourceOrigin.get(this.propertySource, candidate);
                    return ConfigurationProperty.of(this, name, value, origin);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected final Object getPropertySourceProperty(String name) {
        PropertySource<?> propertySource = this.getPropertySource();
        return !this.systemEnvironmentSource ? propertySource.getProperty(name) : this.getSystemEnvironmentProperty((Map)((SystemEnvironmentPropertySource)propertySource).getSource(), name);
    }

    Object getSystemEnvironmentProperty(Map<String, Object> systemEnvironment, String name) {
        Object value = systemEnvironment.get(name);
        return value != null ? value : systemEnvironment.get(name.toLowerCase(Locale.ROOT));
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        PropertySource underlyingPropertySource;
        PropertySource<?> source2 = this.getPropertySource();
        Object underlyingSource = source2.getSource();
        if (underlyingSource instanceof Random) {
            return SpringConfigurationPropertySource.containsDescendantOfForRandom("random", name);
        }
        if (underlyingSource instanceof PropertySource && (underlyingPropertySource = (PropertySource)underlyingSource).getSource() instanceof Random) {
            return SpringConfigurationPropertySource.containsDescendantOfForRandom(source2.getName(), name);
        }
        return ConfigurationPropertyState.UNKNOWN;
    }

    private static ConfigurationPropertyState containsDescendantOfForRandom(String prefix, ConfigurationPropertyName name) {
        if (name.getNumberOfElements() > 1 && name.getElement(0, ConfigurationPropertyName.Form.DASHED).equals(prefix)) {
            return ConfigurationPropertyState.PRESENT;
        }
        return ConfigurationPropertyState.ABSENT;
    }

    @Override
    public Object getUnderlyingSource() {
        return this.propertySource;
    }

    protected PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    protected final boolean isSystemEnvironmentSource() {
        return this.systemEnvironmentSource;
    }

    protected final PropertyMapper[] getMappers() {
        return this.mappers;
    }

    public String toString() {
        return this.propertySource.toString();
    }

    static SpringConfigurationPropertySource from(PropertySource<?> source2) {
        Assert.notNull(source2, "'source' must not be null");
        boolean systemEnvironmentSource = SpringConfigurationPropertySource.isSystemEnvironmentPropertySource(source2);
        PropertyMapper[] mappers = !systemEnvironmentSource ? DEFAULT_MAPPERS : SYSTEM_ENVIRONMENT_MAPPERS;
        return !SpringConfigurationPropertySource.isFullEnumerable(source2) ? new SpringConfigurationPropertySource(source2, systemEnvironmentSource, mappers) : new SpringIterableConfigurationPropertySource((EnumerablePropertySource)source2, systemEnvironmentSource, mappers);
    }

    private static boolean isSystemEnvironmentPropertySource(PropertySource<?> source2) {
        String name = source2.getName();
        return source2 instanceof SystemEnvironmentPropertySource && ("systemEnvironment".equals(name) || name.endsWith("-systemEnvironment"));
    }

    private static boolean isFullEnumerable(PropertySource<?> source2) {
        PropertySource<?> rootSource = SpringConfigurationPropertySource.getRootSource(source2);
        Object obj = rootSource.getSource();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            try {
                map.size();
            }
            catch (UnsupportedOperationException ex) {
                return false;
            }
        }
        return source2 instanceof EnumerablePropertySource;
    }

    private static PropertySource<?> getRootSource(PropertySource<?> source2) {
        Object obj;
        while ((obj = source2.getSource()) instanceof PropertySource) {
            PropertySource propertySource;
            source2 = propertySource = (PropertySource)obj;
        }
        return source2;
    }
}

