/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.convert.ArrayToDelimitedStringConverter;
import org.springframework.boot.convert.CharArrayFormatter;
import org.springframework.boot.convert.CharSequenceToObjectConverter;
import org.springframework.boot.convert.CollectionToDelimitedStringConverter;
import org.springframework.boot.convert.DelimitedStringToArrayConverter;
import org.springframework.boot.convert.DelimitedStringToCollectionConverter;
import org.springframework.boot.convert.DurationToNumberConverter;
import org.springframework.boot.convert.DurationToStringConverter;
import org.springframework.boot.convert.InetAddressFormatter;
import org.springframework.boot.convert.InputStreamSourceToByteArrayConverter;
import org.springframework.boot.convert.IsoOffsetFormatter;
import org.springframework.boot.convert.LenientBooleanToEnumConverterFactory;
import org.springframework.boot.convert.LenientStringToEnumConverterFactory;
import org.springframework.boot.convert.NumberToDataSizeConverter;
import org.springframework.boot.convert.NumberToDurationConverter;
import org.springframework.boot.convert.NumberToPeriodConverter;
import org.springframework.boot.convert.PeriodToStringConverter;
import org.springframework.boot.convert.StringToDataSizeConverter;
import org.springframework.boot.convert.StringToDurationConverter;
import org.springframework.boot.convert.StringToFileConverter;
import org.springframework.boot.convert.StringToPeriodConverter;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ApplicationConversionService
extends FormattingConversionService {
    private static final ResolvableType STRING = ResolvableType.forClass(String.class);
    private static volatile ApplicationConversionService sharedInstance;
    private final boolean unmodifiable;

    public ApplicationConversionService() {
        this(null);
    }

    public ApplicationConversionService(StringValueResolver embeddedValueResolver) {
        this(embeddedValueResolver, false);
    }

    private ApplicationConversionService(StringValueResolver embeddedValueResolver, boolean unmodifiable) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        ApplicationConversionService.configure(this);
        this.unmodifiable = unmodifiable;
    }

    @Override
    public void addPrinter(Printer<?> printer) {
        this.assertModifiable();
        super.addPrinter(printer);
    }

    @Override
    public void addParser(Parser<?> parser) {
        this.assertModifiable();
        super.addParser(parser);
    }

    @Override
    public void addFormatter(Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatter(formatter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, formatter);
    }

    @Override
    public void addConverter(Converter<?, ?> converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, printer, parser);
    }

    @Override
    public void addFormatterForFieldAnnotation(AnnotationFormatterFactory<? extends Annotation> annotationFormatterFactory) {
        this.assertModifiable();
        super.addFormatterForFieldAnnotation(annotationFormatterFactory);
    }

    @Override
    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        this.assertModifiable();
        super.addConverter(sourceType, targetType, converter);
    }

    @Override
    public void addConverter(GenericConverter converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> factory2) {
        this.assertModifiable();
        super.addConverterFactory(factory2);
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.assertModifiable();
        super.removeConvertible(sourceType, targetType);
    }

    private void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("This ApplicationConversionService cannot be modified");
        }
    }

    public boolean isConvertViaObjectSourceType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Set<GenericConverter.ConvertiblePair> pairs;
        GenericConverter converter = this.getConverter(sourceType, targetType);
        Set<GenericConverter.ConvertiblePair> set = pairs = converter != null ? converter.getConvertibleTypes() : null;
        if (pairs != null) {
            for (GenericConverter.ConvertiblePair pair : pairs) {
                if (!Object.class.equals(pair.getSourceType())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getSharedInstance() {
        ApplicationConversionService sharedInstance = ApplicationConversionService.sharedInstance;
        if (sharedInstance != null) return sharedInstance;
        Class<ApplicationConversionService> clazz = ApplicationConversionService.class;
        synchronized (ApplicationConversionService.class) {
            sharedInstance = ApplicationConversionService.sharedInstance;
            if (sharedInstance != null) return sharedInstance;
            ApplicationConversionService.sharedInstance = sharedInstance = new ApplicationConversionService(null, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public static void configure(FormatterRegistry registry) {
        DefaultConversionService.addDefaultConverters(registry);
        DefaultFormattingConversionService.addDefaultFormatters(registry);
        ApplicationConversionService.addApplicationFormatters(registry);
        ApplicationConversionService.addApplicationConverters(registry);
    }

    public static void addApplicationConverters(ConverterRegistry registry) {
        ApplicationConversionService.addDelimitedStringConverters(registry);
        registry.addConverter(new StringToDurationConverter());
        registry.addConverter(new DurationToStringConverter());
        registry.addConverter(new NumberToDurationConverter());
        registry.addConverter(new DurationToNumberConverter());
        registry.addConverter(new StringToPeriodConverter());
        registry.addConverter(new PeriodToStringConverter());
        registry.addConverter(new NumberToPeriodConverter());
        registry.addConverter(new StringToDataSizeConverter());
        registry.addConverter(new NumberToDataSizeConverter());
        registry.addConverter(new StringToFileConverter());
        registry.addConverter(new InputStreamSourceToByteArrayConverter());
        registry.addConverterFactory(new LenientStringToEnumConverterFactory());
        registry.addConverterFactory(new LenientBooleanToEnumConverterFactory());
        if (registry instanceof ConversionService) {
            ConversionService conversionService = (ConversionService)((Object)registry);
            ApplicationConversionService.addApplicationConverters(registry, conversionService);
        }
    }

    private static void addApplicationConverters(ConverterRegistry registry, ConversionService conversionService) {
        registry.addConverter(new CharSequenceToObjectConverter(conversionService));
    }

    public static void addDelimitedStringConverters(ConverterRegistry registry) {
        ConversionService service = (ConversionService)((Object)registry);
        registry.addConverter(new ArrayToDelimitedStringConverter(service));
        registry.addConverter(new CollectionToDelimitedStringConverter(service));
        registry.addConverter(new DelimitedStringToArrayConverter(service));
        registry.addConverter(new DelimitedStringToCollectionConverter(service));
    }

    public static void addApplicationFormatters(FormatterRegistry registry) {
        registry.addFormatter(new CharArrayFormatter());
        registry.addFormatter(new InetAddressFormatter());
        registry.addFormatter(new IsoOffsetFormatter());
    }

    public static void addBeans(FormatterRegistry registry, ListableBeanFactory beanFactory) {
        ApplicationConversionService.addBeans(registry, beanFactory, null);
    }

    public static Map<String, Object> addBeans(FormatterRegistry registry, ListableBeanFactory beanFactory, String qualifier) {
        ConfigurableListableBeanFactory configurableBeanFactory = ApplicationConversionService.getConfigurableListableBeanFactory(beanFactory);
        Map<String, Object> beans2 = ApplicationConversionService.getBeans(beanFactory, qualifier);
        beans2.forEach((beanName, bean2) -> {
            BeanDefinition beanDefinition = configurableBeanFactory != null ? configurableBeanFactory.getMergedBeanDefinition((String)beanName) : null;
            ResolvableType type = beanDefinition != null ? beanDefinition.getResolvableType() : null;
            ApplicationConversionService.addBean(registry, bean2, type);
        });
        return beans2;
    }

    private static ConfigurableListableBeanFactory getConfigurableListableBeanFactory(ListableBeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)beanFactory;
            return applicationContext.getBeanFactory();
        }
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            return configurableListableBeanFactory;
        }
        return null;
    }

    private static Map<String, Object> getBeans(ListableBeanFactory beanFactory, String qualifier) {
        LinkedHashMap<String, Object> beans2 = new LinkedHashMap<String, Object>();
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, Printer.class, qualifier));
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, Parser.class, qualifier));
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, Formatter.class, qualifier));
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, Converter.class, qualifier));
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, ConverterFactory.class, qualifier));
        beans2.putAll(ApplicationConversionService.getBeans(beanFactory, GenericConverter.class, qualifier));
        return beans2;
    }

    private static <T> Map<String, T> getBeans(ListableBeanFactory beanFactory, Class<T> type, String qualifier) {
        return !StringUtils.hasLength(qualifier) ? beanFactory.getBeansOfType(type) : BeanFactoryAnnotationUtils.qualifiedBeansOfType(beanFactory, type, qualifier);
    }

    static void addBean(FormatterRegistry registry, Object bean2, ResolvableType beanType) {
        if (bean2 instanceof GenericConverter) {
            GenericConverter converterBean = (GenericConverter)bean2;
            ApplicationConversionService.addBean(registry, converterBean, beanType, GenericConverter.class, registry::addConverter, (Runnable)null);
        } else if (bean2 instanceof Converter) {
            Converter converterBean = (Converter)bean2;
            ApplicationConversionService.addBean(registry, converterBean, beanType, Converter.class, registry::addConverter, ConverterBeanAdapter::new);
        } else if (bean2 instanceof ConverterFactory) {
            ConverterFactory converterBean = (ConverterFactory)bean2;
            ApplicationConversionService.addBean(registry, converterBean, beanType, ConverterFactory.class, registry::addConverterFactory, ConverterFactoryBeanAdapter::new);
        } else if (bean2 instanceof Formatter) {
            Formatter formatterBean = (Formatter)bean2;
            ApplicationConversionService.addBean(registry, formatterBean, beanType, Formatter.class, registry::addFormatter, () -> {
                registry.addConverter(new PrinterBeanAdapter(formatterBean, beanType));
                registry.addConverter(new ParserBeanAdapter(formatterBean, beanType));
            });
        } else if (bean2 instanceof Printer) {
            Printer printerBean = (Printer)bean2;
            ApplicationConversionService.addBean(registry, printerBean, beanType, Printer.class, registry::addPrinter, PrinterBeanAdapter::new);
        } else if (bean2 instanceof Parser) {
            Parser parserBean = (Parser)bean2;
            ApplicationConversionService.addBean(registry, parserBean, beanType, Parser.class, registry::addParser, ParserBeanAdapter::new);
        }
    }

    private static <B, T> void addBean(FormatterRegistry registry, B bean2, ResolvableType beanType, Class<T> type, Consumer<B> standardRegistrar, BiFunction<B, ResolvableType, BeanAdapter<?>> beanAdapterFactory) {
        ApplicationConversionService.addBean(registry, bean2, beanType, type, standardRegistrar, () -> registry.addConverter((GenericConverter)beanAdapterFactory.apply(bean2, beanType)));
    }

    private static <B, T> void addBean(FormatterRegistry registry, B bean2, ResolvableType beanType, Class<T> type, Consumer<B> standardRegistrar, Runnable beanAdapterRegistrar) {
        if (beanType != null && beanAdapterRegistrar != null && ResolvableType.forInstance(bean2).as(type).hasUnresolvableGenerics()) {
            beanAdapterRegistrar.run();
            return;
        }
        standardRegistrar.accept(bean2);
    }

    static class PrinterBeanAdapter
    extends BeanAdapter<Printer<?>> {
        PrinterBeanAdapter(Printer<?> bean2, ResolvableType beanType) {
            super(bean2, beanType);
        }

        @Override
        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(generics[0], STRING);
        }

        @Override
        public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source2 != null ? this.print(source2) : "";
        }

        private String print(Object object) {
            return ((Printer)this.bean()).print(object, LocaleContextHolder.getLocale());
        }
    }

    static class ParserBeanAdapter
    extends BeanAdapter<Parser<?>> {
        ParserBeanAdapter(Parser<?> bean2, ResolvableType beanType) {
            super(bean2, beanType);
        }

        @Override
        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(STRING, generics[0]);
        }

        @Override
        public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String text = (String)source2;
            return !StringUtils.hasText(text) ? null : this.parse(text);
        }

        private Object parse(String text) {
            try {
                return ((Parser)this.bean()).parse(text, LocaleContextHolder.getLocale());
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
            }
        }
    }

    record ResolvableTypePair(ResolvableType source, ResolvableType target) {
        ResolvableTypePair {
            Assert.notNull(source2.resolve(), "'source' cannot be resolved");
            Assert.notNull(target.resolve(), "'target' cannot be resolved");
        }

        @Override
        public final String toString() {
            return String.valueOf(this.source()) + " -> " + String.valueOf(this.target());
        }
    }

    private static final class ConverterFactoryBeanAdapter
    extends BeanAdapter<ConverterFactory<?, ?>> {
        ConverterFactoryBeanAdapter(ConverterFactory<?, ?> bean2, ResolvableType beanType) {
            super(bean2, beanType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!super.matches(sourceType, targetType)) return false;
            if (!this.conditionalConverterCandidateMatches(this.bean(), sourceType, targetType)) return false;
            if (!this.conditionalConverterCandidateMatches(this.getConverter(targetType::getType), sourceType, targetType)) return false;
            return true;
        }

        @Override
        public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.convert(source2, targetType, this.getConverter(targetType::getObjectType));
        }

        private Converter<Object, ?> getConverter(Supplier<Class<?>> typeSupplier) {
            return ((ConverterFactory)this.bean()).getConverter(typeSupplier.get());
        }
    }

    static final class ConverterBeanAdapter
    extends BeanAdapter<Converter<?, ?>> {
        ConverterBeanAdapter(Converter<?, ?> bean2, ResolvableType beanType) {
            super(bean2, beanType);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return super.matches(sourceType, targetType) && this.conditionalConverterCandidateMatches(this.bean(), sourceType, targetType);
        }

        @Override
        public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.convert(source2, targetType, (Converter)this.bean());
        }
    }

    static abstract class BeanAdapter<B>
    implements ConditionalGenericConverter {
        private final B bean;
        private final ResolvableTypePair types;

        BeanAdapter(B bean2, ResolvableType beanType) {
            Assert.isInstanceOf(beanType.toClass(), bean2);
            ResolvableType type = ResolvableType.forClass(this.getClass()).as(BeanAdapter.class).getGeneric(new int[0]);
            ResolvableType[] generics = beanType.as(type.toClass()).getGenerics();
            this.bean = bean2;
            this.types = this.getResolvableTypePair(generics);
        }

        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(generics[0], generics[1]);
        }

        protected B bean() {
            return this.bean;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Set.of(new GenericConverter.ConvertiblePair(this.types.source().toClass(), this.types.target().toClass()));
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.types.target().toClass() == targetType.getObjectType() && this.matchesTargetType(targetType.getResolvableType());
        }

        private boolean matchesTargetType(ResolvableType targetType) {
            ResolvableType ours = this.types.target();
            return targetType.getType() instanceof Class || targetType.isAssignableFrom(ours) || this.types.target().hasUnresolvableGenerics();
        }

        protected final boolean conditionalConverterCandidateMatches(Object conditionalConverterCandidate, TypeDescriptor sourceType, TypeDescriptor targetType) {
            boolean bl;
            if (conditionalConverterCandidate instanceof ConditionalConverter) {
                ConditionalConverter conditionalConverter = (ConditionalConverter)conditionalConverterCandidate;
                bl = conditionalConverter.matches(sourceType, targetType);
            } else {
                bl = true;
            }
            return bl;
        }

        protected final Object convert(Object source2, TypeDescriptor targetType, Converter<?, ?> converter) {
            return source2 != null ? converter.convert(source2) : this.convertNull(targetType);
        }

        private Object convertNull(TypeDescriptor targetType) {
            return targetType.getObjectType() != Optional.class ? null : Optional.empty();
        }

        public String toString() {
            return String.valueOf(this.types) + " : " + String.valueOf(this.bean);
        }
    }
}

