/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.Empty;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpComponentsRedirectStrategy;
import org.springframework.boot.http.client.HttpComponentsSslBundleTlsStrategy;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.util.Assert;

public final class HttpComponentsHttpAsyncClientBuilder {
    private final Consumer<HttpAsyncClientBuilder> customizer;
    private final Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCustomizer;
    private final Consumer<ConnectionConfig.Builder> connectionConfigCustomizer;
    private final Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer;
    private final Function<SslBundle, TlsStrategy> tlsStrategyFactory;

    public HttpComponentsHttpAsyncClientBuilder() {
        this(Empty.consumer(), Empty.consumer(), Empty.consumer(), Empty.consumer(), HttpComponentsSslBundleTlsStrategy::get);
    }

    private HttpComponentsHttpAsyncClientBuilder(Consumer<HttpAsyncClientBuilder> customizer2, Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCustomizer, Consumer<ConnectionConfig.Builder> connectionConfigCustomizer, Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer, Function<SslBundle, TlsStrategy> tlsStrategyFactory) {
        this.customizer = customizer2;
        this.connectionManagerCustomizer = connectionManagerCustomizer;
        this.connectionConfigCustomizer = connectionConfigCustomizer;
        this.defaultRequestConfigCustomizer = defaultRequestConfigCustomizer;
        this.tlsStrategyFactory = tlsStrategyFactory;
    }

    public HttpComponentsHttpAsyncClientBuilder withCustomizer(Consumer<HttpAsyncClientBuilder> customizer2) {
        Assert.notNull(customizer2, "'customizer' must not be null");
        return new HttpComponentsHttpAsyncClientBuilder(this.customizer.andThen(customizer2), this.connectionManagerCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsStrategyFactory);
    }

    public HttpComponentsHttpAsyncClientBuilder withConnectionManagerCustomizer(Consumer<PoolingAsyncClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, "'connectionManagerCustomizer' must not be null");
        return new HttpComponentsHttpAsyncClientBuilder(this.customizer, this.connectionManagerCustomizer.andThen(connectionManagerCustomizer), this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsStrategyFactory);
    }

    public HttpComponentsHttpAsyncClientBuilder withConnectionConfigCustomizer(Consumer<ConnectionConfig.Builder> connectionConfigCustomizer) {
        Assert.notNull(connectionConfigCustomizer, "'connectionConfigCustomizer' must not be null");
        return new HttpComponentsHttpAsyncClientBuilder(this.customizer, this.connectionManagerCustomizer, this.connectionConfigCustomizer.andThen(connectionConfigCustomizer), this.defaultRequestConfigCustomizer, this.tlsStrategyFactory);
    }

    public HttpComponentsHttpAsyncClientBuilder withTlsStrategyFactory(Function<SslBundle, TlsStrategy> tlsStrategyFactory) {
        Assert.notNull(tlsStrategyFactory, "'tlsStrategyFactory' must not be null");
        return new HttpComponentsHttpAsyncClientBuilder(this.customizer, this.connectionManagerCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, tlsStrategyFactory);
    }

    public HttpComponentsHttpAsyncClientBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, "'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsHttpAsyncClientBuilder(this.customizer, this.connectionManagerCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer.andThen(defaultRequestConfigCustomizer), this.tlsStrategyFactory);
    }

    public CloseableHttpAsyncClient build(HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create().useSystemProperties().setRedirectStrategy(HttpComponentsRedirectStrategy.get(settings.redirects())).setConnectionManager((AsyncClientConnectionManager)this.createConnectionManager(settings)).setDefaultRequestConfig(this.createDefaultRequestConfig());
        this.customizer.accept(builder);
        return builder.build();
    }

    private PoolingAsyncClientConnectionManager createConnectionManager(HttpClientSettings settings) {
        PoolingAsyncClientConnectionManagerBuilder builder = PoolingAsyncClientConnectionManagerBuilder.create().useSystemProperties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        builder.setDefaultConnectionConfig(this.createConnectionConfig(settings));
        map.from(settings::sslBundle).as(this.tlsStrategyFactory).to(arg_0 -> ((PoolingAsyncClientConnectionManagerBuilder)builder).setTlsStrategy(arg_0));
        this.connectionManagerCustomizer.accept(builder);
        return builder.build();
    }

    private ConnectionConfig createConnectionConfig(HttpClientSettings settings) {
        ConnectionConfig.Builder builder = ConnectionConfig.custom();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).as(Duration::toMillis).to(timeout2 -> builder.setConnectTimeout(timeout2.longValue(), TimeUnit.MILLISECONDS));
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(timeout2 -> builder.setSocketTimeout(timeout2.intValue(), TimeUnit.MILLISECONDS));
        this.connectionConfigCustomizer.accept(builder);
        return builder.build();
    }

    private RequestConfig createDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        this.defaultRequestConfigCustomizer.accept(builder);
        return builder.build();
    }
}

