/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.Empty;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.util.Assert;

public final class JettyHttpClientBuilder {
    private final Consumer<HttpClient> customizer;
    private final Consumer<HttpClientTransport> httpClientTransportCustomizer;
    private final Consumer<ClientConnector> clientConnectorCustomizerCustomizer;

    public JettyHttpClientBuilder() {
        this(Empty.consumer(), Empty.consumer(), Empty.consumer());
    }

    private JettyHttpClientBuilder(Consumer<HttpClient> customizer2, Consumer<HttpClientTransport> httpClientTransportCustomizer, Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        this.customizer = customizer2;
        this.httpClientTransportCustomizer = httpClientTransportCustomizer;
        this.clientConnectorCustomizerCustomizer = clientConnectorCustomizerCustomizer;
    }

    public JettyHttpClientBuilder withCustomizer(Consumer<HttpClient> customizer2) {
        Assert.notNull(customizer2, "'customizer' must not be null");
        return new JettyHttpClientBuilder(this.customizer.andThen(customizer2), this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer);
    }

    public JettyHttpClientBuilder withHttpClientTransportCustomizer(Consumer<HttpClientTransport> httpClientTransportCustomizer) {
        Assert.notNull(httpClientTransportCustomizer, "'httpClientTransportCustomizer' must not be null");
        return new JettyHttpClientBuilder(this.customizer, this.httpClientTransportCustomizer.andThen(httpClientTransportCustomizer), this.clientConnectorCustomizerCustomizer);
    }

    public JettyHttpClientBuilder withClientConnectorCustomizerCustomizer(Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        Assert.notNull(clientConnectorCustomizerCustomizer, "'clientConnectorCustomizerCustomizer' must not be null");
        return new JettyHttpClientBuilder(this.customizer, this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer.andThen(clientConnectorCustomizerCustomizer));
    }

    public HttpClient build(HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        HttpClientTransport transport = this.createTransport(settings);
        this.httpClientTransportCustomizer.accept(transport);
        HttpClient httpClient = this.createHttpClient(settings.readTimeout(), transport);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).as(Duration::toMillis).to(arg_0 -> ((HttpClient)httpClient).setConnectTimeout(arg_0));
        map.from(settings::redirects).as(this::followRedirects).to(arg_0 -> ((HttpClient)httpClient).setFollowRedirects(arg_0));
        this.customizer.accept(httpClient);
        return httpClient;
    }

    private HttpClient createHttpClient(Duration readTimeout, HttpClientTransport transport) {
        return readTimeout != null ? new HttpClientWithReadTimeout(transport, readTimeout) : new HttpClient(transport);
    }

    private HttpClientTransport createTransport(HttpClientSettings settings) {
        ClientConnector connector = this.createClientConnector(settings.sslBundle());
        return connector.getSslContextFactory() != null ? new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[0]) : new HttpClientTransportOverHTTP(connector);
    }

    private ClientConnector createClientConnector(SslBundle sslBundle) {
        ClientConnector connector = new ClientConnector();
        if (sslBundle != null) {
            connector.setSslContextFactory(this.createSslContextFactory(sslBundle));
        }
        this.clientConnectorCustomizerCustomizer.accept(connector);
        return connector;
    }

    private SslContextFactory.Client createSslContextFactory(SslBundle sslBundle) {
        SslOptions options = sslBundle.getOptions();
        SSLContext sslContext = sslBundle.createSslContext();
        SslContextFactory.Client factory2 = new SslContextFactory.Client();
        factory2.setSslContext(sslContext);
        if (options.getCiphers() != null) {
            factory2.setIncludeCipherSuites(options.getCiphers());
            factory2.setExcludeCipherSuites(new String[0]);
        }
        if (options.getEnabledProtocols() != null) {
            factory2.setIncludeProtocols(options.getEnabledProtocols());
            factory2.setExcludeProtocols(new String[0]);
        }
        return factory2;
    }

    private boolean followRedirects(HttpRedirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case HttpRedirects.FOLLOW_WHEN_POSSIBLE, HttpRedirects.FOLLOW -> true;
            case HttpRedirects.DONT_FOLLOW -> false;
        };
    }

    static class HttpClientWithReadTimeout
    extends HttpClient {
        private final Duration readTimeout;

        HttpClientWithReadTimeout(HttpClientTransport transport, Duration readTimeout) {
            super(transport);
            this.readTimeout = readTimeout;
        }

        public Request newRequest(URI uri) {
            Request request = super.newRequest(uri);
            request.timeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            return request;
        }
    }
}

