/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.ReactorHttpClientBuilder;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.netty.http.client.HttpClient;

public final class ReactorClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<ReactorClientHttpRequestFactory> {
    private final ReactorHttpClientBuilder httpClientBuilder;

    ReactorClientHttpRequestFactoryBuilder() {
        this(null, new ReactorHttpClientBuilder());
    }

    private ReactorClientHttpRequestFactoryBuilder(List<Consumer<ReactorClientHttpRequestFactory>> customizers, ReactorHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public ReactorClientHttpRequestFactoryBuilder withCustomizer(Consumer<ReactorClientHttpRequestFactory> customizer2) {
        return new ReactorClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer2), this.httpClientBuilder);
    }

    public ReactorClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<ReactorClientHttpRequestFactory>> customizers) {
        return new ReactorClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public ReactorClientHttpRequestFactoryBuilder withReactorResourceFactory(ReactorResourceFactory reactorResourceFactory) {
        Assert.notNull((Object)reactorResourceFactory, "'reactorResourceFactory' must not be null");
        return new ReactorClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withReactorResourceFactory(reactorResourceFactory));
    }

    public ReactorClientHttpRequestFactoryBuilder withHttpClientFactory(Supplier<HttpClient> factory2) {
        Assert.notNull(factory2, "'factory' must not be null");
        return new ReactorClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientFactory(factory2));
    }

    public ReactorClientHttpRequestFactoryBuilder withHttpClientCustomizer(UnaryOperator<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'httpClientCustomizer' must not be null");
        return new ReactorClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientCustomizer(httpClientCustomizer));
    }

    @Override
    protected ReactorClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings.withTimeouts(null, null)));
        ReactorClientHttpRequestFactory requestFactory = new ReactorClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
        return requestFactory;
    }

    static class Classes {
        static final String HTTP_CLIENT = "reactor.netty.http.client.HttpClient";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent(HTTP_CLIENT, classLoader);
        }
    }
}

