/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import java.time.Duration;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLException;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingConsumer;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;

public final class ReactorHttpClientBuilder {
    private final Supplier<HttpClient> factory;
    private final UnaryOperator<HttpClient> customizer;

    public ReactorHttpClientBuilder() {
        this(HttpClient::create, UnaryOperator.identity());
    }

    private ReactorHttpClientBuilder(Supplier<HttpClient> httpClientFactory, UnaryOperator<HttpClient> customizer2) {
        this.factory = httpClientFactory;
        this.customizer = customizer2;
    }

    public ReactorHttpClientBuilder withReactorResourceFactory(ReactorResourceFactory reactorResourceFactory) {
        Assert.notNull((Object)reactorResourceFactory, "'reactorResourceFactory' must not be null");
        return new ReactorHttpClientBuilder(() -> HttpClient.create((ConnectionProvider)reactorResourceFactory.getConnectionProvider()), httpClient -> (HttpClient)((HttpClient)this.customizer.apply((HttpClient)httpClient)).runOn(reactorResourceFactory.getLoopResources()));
    }

    public ReactorHttpClientBuilder withHttpClientFactory(Supplier<HttpClient> factory2) {
        Assert.notNull(factory2, "'factory' must not be null");
        return new ReactorHttpClientBuilder(factory2, this.customizer);
    }

    public ReactorHttpClientBuilder withHttpClientCustomizer(UnaryOperator<HttpClient> customizer2) {
        Assert.notNull(customizer2, "'customizer' must not be null");
        return new ReactorHttpClientBuilder(this.factory, httpClient -> (HttpClient)customizer2.apply((HttpClient)this.customizer.apply((HttpClient)httpClient)));
    }

    public HttpClient build(HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        HttpClient httpClient = this.applyDefaults(this.factory.get());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        httpClient = map.from(settings::connectTimeout).to(httpClient, this::setConnectTimeout);
        httpClient = map.from(settings::readTimeout).to(httpClient, HttpClient::responseTimeout);
        httpClient = map.from(settings::redirects).as(this::followRedirects).to(httpClient, HttpClient::followRedirect);
        httpClient = map.from(settings::sslBundle).to(httpClient, this::secure);
        return (HttpClient)this.customizer.apply(httpClient);
    }

    HttpClient applyDefaults(HttpClient httpClient) {
        return httpClient.compress(true);
    }

    private HttpClient setConnectTimeout(HttpClient httpClient, Duration timeout2) {
        return (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)timeout2.toMillis()));
    }

    private boolean followRedirects(HttpRedirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case HttpRedirects.FOLLOW_WHEN_POSSIBLE, HttpRedirects.FOLLOW -> true;
            case HttpRedirects.DONT_FOLLOW -> false;
        };
    }

    private HttpClient secure(HttpClient httpClient, SslBundle sslBundle) {
        return httpClient.secure(ThrowingConsumer.of(spec -> this.configureSsl((SslProvider.SslContextSpec)spec, sslBundle)));
    }

    private void configureSsl(SslProvider.SslContextSpec spec, SslBundle sslBundle) throws SSLException {
        SslOptions options = sslBundle.getOptions();
        SslManagerBundle managers = sslBundle.getManagers();
        SslContextBuilder builder = SslContextBuilder.forClient().keyManager(managers.getKeyManagerFactory()).trustManager(managers.getTrustManagerFactory()).ciphers(SslOptions.asSet(options.getCiphers())).protocols(options.getEnabledProtocols());
        spec.sslContext(builder.build());
    }
}

