/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.boot.logging.logback.Extractor;
import org.springframework.boot.logging.structured.ContextPairs;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;

class LogstashStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<ILoggingEvent> {
    private static final JsonWriter.PairExtractor<KeyValuePair> keyValuePairExtractor = JsonWriter.PairExtractor.of(pair -> pair.key, pair -> pair.value);

    LogstashStructuredLogFormatter(StackTracePrinter stackTracePrinter, ContextPairs contextPairs, ThrowableProxyConverter throwableProxyConverter, StructuredLoggingJsonMembersCustomizer<?> customizer2) {
        super(members -> LogstashStructuredLogFormatter.jsonMembers(stackTracePrinter, contextPairs, throwableProxyConverter, members), customizer2);
    }

    private static void jsonMembers(StackTracePrinter stackTracePrinter, ContextPairs contextPairs, ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        Extractor extractor = new Extractor(stackTracePrinter, throwableProxyConverter);
        members.add("@timestamp", ILoggingEvent::getInstant).as(LogstashStructuredLogFormatter::asTimestamp);
        members.add("@version", "1");
        members.add("message", ILoggingEvent::getFormattedMessage);
        members.add("logger_name", ILoggingEvent::getLoggerName);
        members.add("thread_name", ILoggingEvent::getThreadName);
        members.add("level", ILoggingEvent::getLevel);
        members.add("level_value", ILoggingEvent::getLevel).as(Level::toInt);
        members.add().usingPairs(contextPairs.flat("_", pairs -> {
            pairs.addMapEntries(ILoggingEvent::getMDCPropertyMap);
            pairs.add(ILoggingEvent::getKeyValuePairs, keyValuePairExtractor);
        }));
        members.add("tags", ILoggingEvent::getMarkerList).whenNotNull().as(LogstashStructuredLogFormatter::getMarkers).whenNotEmpty();
        members.add("stack_trace", event -> event).whenNotNull(ILoggingEvent::getThrowableProxy).as(extractor::stackTrace);
    }

    private static String asTimestamp(Instant instant) {
        OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
    }

    private static Set<String> getMarkers(List<Marker> markers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LogstashStructuredLogFormatter.addMarkers(result, markers.iterator());
        return result;
    }

    private static void addMarkers(Set<String> result, Iterator<Marker> iterator2) {
        while (iterator2.hasNext()) {
            Marker marker = iterator2.next();
            result.add(marker.getName());
            if (!marker.hasReferences()) continue;
            LogstashStructuredLogFormatter.addMarkers(result, marker.iterator());
        }
    }
}

