/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MimeMappings
implements Iterable<Mapping> {
    public static final MimeMappings DEFAULT = new DefaultMimeMappings();
    private final Map<String, Mapping> map;

    public MimeMappings() {
        this.map = new LinkedHashMap<String, Mapping>();
    }

    public MimeMappings(MimeMappings mappings) {
        this(mappings, true);
    }

    public MimeMappings(Map<String, String> mappings) {
        Assert.notNull(mappings, "'mappings' must not be null");
        this.map = new LinkedHashMap<String, Mapping>();
        mappings.forEach(this::add);
    }

    MimeMappings(MimeMappings mappings, boolean mutable) {
        Assert.notNull((Object)mappings, "'mappings' must not be null");
        this.map = mutable ? new LinkedHashMap<String, Mapping>(mappings.map) : Collections.unmodifiableMap(mappings.map);
    }

    public String add(String extension, String mimeType) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        Assert.notNull((Object)mimeType, "'mimeType' must not be null");
        Mapping previous = this.map.put(extension.toLowerCase(Locale.ENGLISH), new Mapping(extension, mimeType));
        return previous != null ? previous.getMimeType() : null;
    }

    public String remove(String extension) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        Mapping previous = this.map.remove(extension.toLowerCase(Locale.ENGLISH));
        return previous != null ? previous.getMimeType() : null;
    }

    public String get(String extension) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        Mapping mapping = this.map.get(extension.toLowerCase(Locale.ENGLISH));
        return mapping != null ? mapping.getMimeType() : null;
    }

    public Collection<Mapping> getAll() {
        return this.map.values();
    }

    @Override
    public final Iterator<Mapping> iterator() {
        return this.getAll().iterator();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MimeMappings) {
            MimeMappings other = (MimeMappings)obj;
            return this.getMap().equals(other.map);
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    Map<String, Mapping> getMap() {
        return this.map;
    }

    public static MimeMappings unmodifiableMappings(MimeMappings mappings) {
        Assert.notNull((Object)mappings, "'mappings' must not be null");
        return new MimeMappings(mappings, false);
    }

    public static MimeMappings lazyCopy(MimeMappings mappings) {
        Assert.notNull((Object)mappings, "'mappings' must not be null");
        return new LazyMimeMappingsCopy(mappings);
    }

    public static final class Mapping {
        private final String extension;
        private final String mimeType;

        public Mapping(String extension, String mimeType) {
            Assert.notNull((Object)extension, "'extension' must not be null");
            Assert.notNull((Object)mimeType, "'mimeType' must not be null");
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof Mapping) {
                Mapping other = (Mapping)obj;
                return this.extension.equals(other.extension) && this.mimeType.equals(other.mimeType);
            }
            return false;
        }

        public int hashCode() {
            return this.extension.hashCode();
        }

        public String toString() {
            return "Mapping [extension=" + this.extension + ", mimeType=" + this.mimeType + "]";
        }
    }

    static final class LazyMimeMappingsCopy
    extends MimeMappings {
        private final MimeMappings source;
        private final AtomicBoolean copied = new AtomicBoolean();

        LazyMimeMappingsCopy(MimeMappings source2) {
            this.source = source2;
        }

        @Override
        public String add(String extension, String mimeType) {
            this.copyIfNecessary();
            return super.add(extension, mimeType);
        }

        @Override
        public String remove(String extension) {
            this.copyIfNecessary();
            return super.remove(extension);
        }

        private void copyIfNecessary() {
            if (this.copied.compareAndSet(false, true)) {
                this.source.forEach(mapping -> this.add(mapping.getExtension(), mapping.getMimeType()));
            }
        }

        @Override
        public String get(String extension) {
            return !this.copied.get() ? this.source.get(extension) : super.get(extension);
        }

        @Override
        public Collection<Mapping> getAll() {
            return !this.copied.get() ? this.source.getAll() : super.getAll();
        }

        @Override
        Map<String, Mapping> getMap() {
            return !this.copied.get() ? this.source.getMap() : super.getMap();
        }
    }

    static final class DefaultMimeMappings
    extends MimeMappings {
        static final String MIME_MAPPINGS_PROPERTIES = "mime-mappings.properties";
        private static final MimeMappings COMMON;
        private volatile Map<String, Mapping> loaded;

        DefaultMimeMappings() {
            super(new MimeMappings(), false);
        }

        @Override
        public Collection<Mapping> getAll() {
            return this.load().values();
        }

        @Override
        public String get(String extension) {
            Assert.notNull((Object)extension, "'extension' must not be null");
            extension = extension.toLowerCase(Locale.ENGLISH);
            Map<String, Mapping> loaded = this.loaded;
            if (loaded != null) {
                return this.get(loaded, extension);
            }
            String commonMimeType = COMMON.get(extension);
            if (commonMimeType != null) {
                return commonMimeType;
            }
            loaded = this.load();
            return this.get(loaded, extension);
        }

        private String get(Map<String, Mapping> mappings, String extension) {
            Mapping mapping = mappings.get(extension);
            return mapping != null ? mapping.getMimeType() : null;
        }

        @Override
        Map<String, Mapping> getMap() {
            return this.load();
        }

        private Map<String, Mapping> load() {
            Map<String, Mapping> loaded = this.loaded;
            if (loaded != null) {
                return loaded;
            }
            try {
                loaded = new LinkedHashMap<String, Mapping>();
                for (Map.Entry<Object, Object> entry : PropertiesLoaderUtils.loadProperties(new ClassPathResource(MIME_MAPPINGS_PROPERTIES, this.getClass())).entrySet()) {
                    loaded.put((String)entry.getKey(), new Mapping((String)entry.getKey(), (String)entry.getValue()));
                }
                this.loaded = loaded = Collections.unmodifiableMap(loaded);
                return loaded;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to load the default MIME types", ex);
            }
        }

        static {
            MimeMappings mappings = new MimeMappings();
            mappings.add("avi", "video/x-msvideo");
            mappings.add("bin", "application/octet-stream");
            mappings.add("body", "text/html");
            mappings.add("class", "application/java");
            mappings.add("css", "text/css");
            mappings.add("dtd", "application/xml-dtd");
            mappings.add("gif", "image/gif");
            mappings.add("gtar", "application/x-gtar");
            mappings.add("gz", "application/x-gzip");
            mappings.add("htm", "text/html");
            mappings.add("html", "text/html");
            mappings.add("jar", "application/java-archive");
            mappings.add("java", "text/x-java-source");
            mappings.add("jnlp", "application/x-java-jnlp-file");
            mappings.add("jpe", "image/jpeg");
            mappings.add("jpeg", "image/jpeg");
            mappings.add("jpg", "image/jpeg");
            mappings.add("js", "text/javascript");
            mappings.add("json", "application/json");
            mappings.add("otf", "font/otf");
            mappings.add("pdf", "application/pdf");
            mappings.add("png", "image/png");
            mappings.add("ps", "application/postscript");
            mappings.add("tar", "application/x-tar");
            mappings.add("tif", "image/tiff");
            mappings.add("tiff", "image/tiff");
            mappings.add("ttf", "font/ttf");
            mappings.add("txt", "text/plain");
            mappings.add("xht", "application/xhtml+xml");
            mappings.add("xhtml", "application/xhtml+xml");
            mappings.add("xls", "application/vnd.ms-excel");
            mappings.add("xml", "application/xml");
            mappings.add("xsl", "application/xml");
            mappings.add("xslt", "application/xslt+xml");
            mappings.add("wasm", "application/wasm");
            mappings.add("zip", "application/zip");
            COMMON = DefaultMimeMappings.unmodifiableMappings(mappings);
        }
    }

    static class MimeMappingsRuntimeHints
    implements RuntimeHintsRegistrar {
        MimeMappingsRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("org/springframework/boot/web/server/mime-mappings.properties");
        }
    }
}

