/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.classify.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aop.framework.Advised;
import org.springframework.classify.util.MethodInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleMethodInvoker
implements MethodInvoker {
    private final Object object;
    private final Method method;
    private final Class<?>[] parameterTypes;
    private volatile Object target;

    public SimpleMethodInvoker(Object object, Method method) {
        Assert.notNull(object, "Object to invoke must not be null");
        Assert.notNull((Object)method, "Method to invoke must not be null");
        this.method = method;
        method.setAccessible(true);
        this.object = object;
        this.parameterTypes = method.getParameterTypes();
    }

    public SimpleMethodInvoker(Object object, String methodName, Class<?> ... paramTypes) {
        Assert.notNull(object, "Object to invoke must not be null");
        Method method = ClassUtils.getMethodIfAvailable(object.getClass(), methodName, paramTypes);
        if (method == null) {
            method = ClassUtils.getMethodIfAvailable(object.getClass(), methodName, new Class[0]);
        }
        Assert.notNull((Object)method, "No methods found for name: [" + methodName + "] in class: [" + String.valueOf(object.getClass()) + "] with arguments of type: [" + Arrays.toString(paramTypes) + "]");
        this.object = object;
        this.method = method;
        method.setAccessible(true);
        this.parameterTypes = method.getParameterTypes();
    }

    @Override
    public Object invokeMethod(Object ... args2) {
        Assert.state(this.parameterTypes.length == args2.length, "Wrong number of arguments, expected no more than: [" + this.parameterTypes.length + "]");
        try {
            Object target = this.extractTarget(this.object, this.method);
            return this.method.invoke(target, args2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to invoke method: [" + String.valueOf(this.method) + "] on object: [" + String.valueOf(this.object) + "] with arguments: [" + Arrays.toString(args2) + "]", e);
        }
    }

    private Object extractTarget(Object target, Method method) {
        if (this.target == null) {
            if (target instanceof Advised) {
                Object source2;
                try {
                    source2 = ((Advised)target).getTargetSource().getTarget();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not extract target from proxy", e);
                }
                if (source2 instanceof Advised) {
                    source2 = this.extractTarget(source2, method);
                }
                if (method.getDeclaringClass().isAssignableFrom(source2.getClass())) {
                    target = source2;
                }
            }
            this.target = target;
        }
        return this.target;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleMethodInvoker)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SimpleMethodInvoker rhs = (SimpleMethodInvoker)obj;
        return rhs.method.equals(this.method) && rhs.object.equals(this.object);
    }

    public int hashCode() {
        int result = 25;
        result = 31 * result + this.object.hashCode();
        result = 31 * result + this.method.hashCode();
        return result;
    }
}

