/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.lang.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum IntrospectionFailureLogger {
    DEBUG{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isDebugEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().debug(message);
        }
    }
    ,
    INFO{

        @Override
        public boolean isEnabled() {
            return IntrospectionFailureLogger.getLogger().isInfoEnabled();
        }

        @Override
        public void log(String message) {
            IntrospectionFailureLogger.getLogger().info(message);
        }
    };

    @Nullable
    private static Log logger;

    void log(String message, @Nullable Object source2, Exception ex) {
        String on = source2 != null ? " on " + String.valueOf(source2) : "";
        this.log(message + on + ": " + String.valueOf(ex));
    }

    abstract boolean isEnabled();

    abstract void log(String var1);

    private static Log getLogger() {
        Log logger2 = logger;
        if (logger2 == null) {
            logger = logger2 = LogFactory.getLog(MergedAnnotation.class);
        }
        return logger2;
    }
}

