/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;

final class AnnotationAuditingMetadata {
    private static final ReflectionUtils.AnnotationFieldFilter CREATED_BY_FILTER = new ReflectionUtils.AnnotationFieldFilter(CreatedBy.class);
    private static final ReflectionUtils.AnnotationFieldFilter CREATED_DATE_FILTER = new ReflectionUtils.AnnotationFieldFilter(CreatedDate.class);
    private static final ReflectionUtils.AnnotationFieldFilter LAST_MODIFIED_BY_FILTER = new ReflectionUtils.AnnotationFieldFilter(LastModifiedBy.class);
    private static final ReflectionUtils.AnnotationFieldFilter LAST_MODIFIED_DATE_FILTER = new ReflectionUtils.AnnotationFieldFilter(LastModifiedDate.class);
    static final List<String> SUPPORTED_DATE_TYPES;
    private final Optional<Field> createdByField;
    private final Optional<Field> createdDateField;
    private final Optional<Field> lastModifiedByField;
    private final Optional<Field> lastModifiedDateField;

    private AnnotationAuditingMetadata(Class<?> type) {
        Assert.notNull(type, "Given type must not be null");
        this.createdByField = Optional.ofNullable(ReflectionUtils.findField(type, CREATED_BY_FILTER));
        this.createdDateField = Optional.ofNullable(ReflectionUtils.findField(type, CREATED_DATE_FILTER));
        this.lastModifiedByField = Optional.ofNullable(ReflectionUtils.findField(type, LAST_MODIFIED_BY_FILTER));
        this.lastModifiedDateField = Optional.ofNullable(ReflectionUtils.findField(type, LAST_MODIFIED_DATE_FILTER));
        this.assertValidDateFieldType(this.createdDateField);
        this.assertValidDateFieldType(this.lastModifiedDateField);
    }

    private void assertValidDateFieldType(Optional<Field> field) {
        field.ifPresent(it -> {
            if (SUPPORTED_DATE_TYPES.contains(it.getType().getName())) {
                return;
            }
            Class<?> type = it.getType();
            if (TemporalAccessor.class.isAssignableFrom(type)) {
                return;
            }
            throw new IllegalStateException(String.format("Found created/modified date field with type %s but only %s as well as java.time types are supported", type, SUPPORTED_DATE_TYPES));
        });
    }

    public static AnnotationAuditingMetadata getMetadata(Class<?> type) {
        return new AnnotationAuditingMetadata(type);
    }

    public boolean isAuditable() {
        return Optionals.isAnyPresent(this.createdByField, this.createdDateField, this.lastModifiedByField, this.lastModifiedDateField);
    }

    public Optional<Field> getCreatedByField() {
        return this.createdByField;
    }

    public Optional<Field> getCreatedDateField() {
        return this.createdDateField;
    }

    public Optional<Field> getLastModifiedByField() {
        return this.lastModifiedByField;
    }

    public Optional<Field> getLastModifiedDateField() {
        return this.lastModifiedDateField;
    }

    static {
        ArrayList<String> types = new ArrayList<String>(Jsr310Converters.getSupportedClasses().stream().filter(TemporalAccessor.class::isAssignableFrom).map(Class::getName).toList());
        types.add(Date.class.getName());
        types.add(Long.class.getName());
        types.add(Long.TYPE.getName());
        SUPPORTED_DATE_TYPES = Collections.unmodifiableList(types);
    }
}

