/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import org.springframework.data.auditing.AuditingHandlerSupport;
import org.springframework.data.auditing.Auditor;
import org.springframework.data.domain.ReactiveAuditorAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveAuditingHandler
extends AuditingHandlerSupport {
    private ReactiveAuditorAware<?> auditorAware = Mono::empty;

    public ReactiveAuditingHandler(PersistentEntities entities) {
        super(entities);
    }

    public static ReactiveAuditingHandler from(MappingContext<?, ?> mappingContext) {
        return new ReactiveAuditingHandler(PersistentEntities.of(mappingContext));
    }

    public void setAuditorAware(ReactiveAuditorAware<?> auditorAware) {
        Assert.notNull(auditorAware, "AuditorAware must not be null");
        this.auditorAware = auditorAware;
    }

    public <T> Mono<T> markCreated(T source2) {
        Assert.notNull(source2, "Entity must not be null");
        return this.getAuditor().map(auditor -> this.markCreated((Auditor<?>)auditor, source2));
    }

    public <T> Mono<T> markModified(T source2) {
        Assert.notNull(source2, "Entity must not be null");
        return this.getAuditor().map(auditor -> this.markModified((Auditor<?>)auditor, source2));
    }

    private Mono<? extends Auditor<?>> getAuditor() {
        return this.auditorAware.getCurrentAuditor().map(Auditor::of).defaultIfEmpty(Auditor.none());
    }
}

