/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.domain.FloatVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.ObjectUtils;

class DoubleVector
implements Vector {
    static final DoubleVector EMPTY = new DoubleVector(new double[0]){

        @Override
        public float[] toFloatArray() {
            return FloatVector.EMPTY.v;
        }

        @Override
        public double[] toDoubleArray() {
            return this.v;
        }
    };
    final double[] v;

    DoubleVector(double[] v) {
        this.v = v;
    }

    static Vector copy(double[] v) {
        if (v.length == 0) {
            return EMPTY;
        }
        return new DoubleVector(Arrays.copyOf(v, v.length));
    }

    static Vector copy(Collection<? extends Number> v) {
        if (v.isEmpty()) {
            return EMPTY;
        }
        double[] copy = new double[v.size()];
        int i2 = 0;
        for (Number number : v) {
            copy[i2++] = number.doubleValue();
        }
        return new DoubleVector(copy);
    }

    public Class<Double> getType() {
        return Double.TYPE;
    }

    @Override
    public Object getSource() {
        return this.v;
    }

    @Override
    public int size() {
        return this.v.length;
    }

    @Override
    public float[] toFloatArray() {
        float[] copy = new float[this.v.length];
        for (int i2 = 0; i2 < this.v.length; ++i2) {
            copy[i2] = (float)this.v[i2];
        }
        return copy;
    }

    @Override
    public double[] toDoubleArray() {
        return Arrays.copyOf(this.v, this.v.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleVector)) {
            return false;
        }
        DoubleVector that = (DoubleVector)o;
        return ObjectUtils.nullSafeEquals(this.v, that.v);
    }

    public int hashCode() {
        return Arrays.hashCode(this.v);
    }

    public String toString() {
        return "D" + Arrays.toString(this.v);
    }
}

