/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.domain.DoubleVector;
import org.springframework.data.domain.FloatVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class NumberVector
implements Vector {
    static final NumberVector EMPTY = new NumberVector(new Number[0]){

        @Override
        public float[] toFloatArray() {
            return FloatVector.EMPTY.v;
        }

        @Override
        public double[] toDoubleArray() {
            return DoubleVector.EMPTY.v;
        }
    };
    private final Number[] v;

    NumberVector(Number[] v) {
        Assert.noNullElements((Object[])v, "Vector [v] must not contain null elements");
        this.v = v;
    }

    static Vector copy(Number[] v) {
        if (v.length == 0) {
            return EMPTY;
        }
        return new NumberVector(Arrays.copyOf(v, v.length));
    }

    static Vector copy(Collection<? extends Number> v) {
        if (v.isEmpty()) {
            return EMPTY;
        }
        return new NumberVector((Number[])v.toArray(Number[]::new));
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.v.length == 0) {
            return Number.class;
        }
        Class<?> candidate = this.v[0].getClass();
        for (int i2 = 1; i2 < this.v.length; ++i2) {
            if (candidate == this.v[i2].getClass()) continue;
            return Number.class;
        }
        return candidate;
    }

    @Override
    public Object getSource() {
        return this.v;
    }

    @Override
    public int size() {
        return this.v.length;
    }

    @Override
    public float[] toFloatArray() {
        float[] copy = new float[this.v.length];
        for (int i2 = 0; i2 < this.v.length; ++i2) {
            copy[i2] = this.v[i2].floatValue();
        }
        return copy;
    }

    @Override
    public double[] toDoubleArray() {
        double[] copy = new double[this.v.length];
        for (int i2 = 0; i2 < this.v.length; ++i2) {
            copy[i2] = this.v[i2].doubleValue();
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberVector)) {
            return false;
        }
        NumberVector that = (NumberVector)o;
        return ObjectUtils.nullSafeEquals(this.v, that.v);
    }

    public int hashCode() {
        return Arrays.hashCode(this.v);
    }

    public String toString() {
        return "N" + Arrays.toString(this.v);
    }
}

