/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Map;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;

public interface ScrollPosition {
    public boolean isInitial();

    public static KeysetScrollPosition keyset() {
        return KeysetScrollPosition.initial();
    }

    public static OffsetScrollPosition offset() {
        return OffsetScrollPosition.initial();
    }

    public static OffsetScrollPosition offset(long offset) {
        return OffsetScrollPosition.of(offset);
    }

    public static KeysetScrollPosition forward(Map<String, ?> keys2) {
        return ScrollPosition.of(keys2, Direction.FORWARD);
    }

    public static KeysetScrollPosition backward(Map<String, ?> keys2) {
        return ScrollPosition.of(keys2, Direction.BACKWARD);
    }

    public static KeysetScrollPosition of(Map<String, ?> keys2, Direction direction) {
        return KeysetScrollPosition.of(keys2, direction);
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;


        Direction reverse() {
            return this == FORWARD ? BACKWARD : FORWARD;
        }
    }
}

