/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Collection;
import org.springframework.data.domain.DoubleVector;
import org.springframework.data.domain.FloatVector;
import org.springframework.data.domain.NumberVector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public interface Vector {
    public static Vector of(float ... values2) {
        Assert.notNull((Object)values2, "float vector values must not be null");
        return FloatVector.copy(values2);
    }

    public static Vector of(double ... values2) {
        Assert.notNull((Object)values2, "double vector values must not be null");
        return DoubleVector.copy(values2);
    }

    public static Vector of(Collection<? extends Number> values2) {
        Assert.notNull(values2, "Vector values must not be null");
        if (values2.isEmpty()) {
            return NumberVector.EMPTY;
        }
        Class<?> cet = CollectionUtils.findCommonElementType(values2);
        if (cet == Double.class) {
            return DoubleVector.copy(values2);
        }
        if (cet == Float.class) {
            return FloatVector.copy(values2);
        }
        return NumberVector.copy(values2);
    }

    public static Vector unsafe(float[] values2) {
        Assert.notNull((Object)values2, "float vector values must not be null");
        return new FloatVector(values2);
    }

    public static Vector unsafe(double[] values2) {
        Assert.notNull((Object)values2, "double vector values must not be null");
        return new DoubleVector(values2);
    }

    public Class<? extends Number> getType();

    public Object getSource();

    public int size();

    public float[] toFloatArray();

    public double[] toDoubleArray();
}

