/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.expression;

import java.util.ArrayList;
import org.springframework.data.expression.CompositeValueExpression;
import org.springframework.data.expression.ExpressionExpression;
import org.springframework.data.expression.LiteralValueExpression;
import org.springframework.data.expression.PlaceholderExpression;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.expression.ValueParserConfiguration;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class DefaultValueExpressionParser
implements ValueExpressionParser {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String EXPRESSION_PREFIX = ParserContext.TEMPLATE_EXPRESSION.getExpressionPrefix();
    public static final char SUFFIX = '}';
    public static final int PLACEHOLDER_PREFIX_LENGTH = "${".length();
    public static final char[] QUOTE_CHARS = new char[]{'\'', '\"'};
    public static final ValueExpressionParser DEFAULT = new DefaultValueExpressionParser(SpelExpressionParser::new);
    private final ValueParserConfiguration configuration;

    public DefaultValueExpressionParser(ValueParserConfiguration configuration) {
        Assert.notNull((Object)configuration, "ValueParserConfiguration must not be null");
        this.configuration = configuration;
    }

    @Override
    public ValueExpression parse(String expressionString) {
        int placerholderIndex = expressionString.indexOf(PLACEHOLDER_PREFIX);
        int expressionIndex = expressionString.indexOf(EXPRESSION_PREFIX);
        if (placerholderIndex == -1 && expressionIndex == -1) {
            return new LiteralValueExpression(expressionString);
        }
        if (placerholderIndex != -1 && expressionIndex == -1 && DefaultValueExpressionParser.findPlaceholderEndIndex(expressionString, placerholderIndex) != expressionString.length()) {
            return this.createPlaceholder(expressionString);
        }
        if (placerholderIndex == -1 && DefaultValueExpressionParser.findPlaceholderEndIndex(expressionString, expressionIndex) != expressionString.length()) {
            return this.createExpression(expressionString);
        }
        return this.parseComposite(expressionString, placerholderIndex, expressionIndex);
    }

    private CompositeValueExpression parseComposite(String expressionString, int placerholderIndex, int expressionIndex) {
        ArrayList<ValueExpression> expressions = new ArrayList<ValueExpression>(PLACEHOLDER_PREFIX_LENGTH);
        int startIndex = DefaultValueExpressionParser.getStartIndex(placerholderIndex, expressionIndex);
        if (startIndex != 0) {
            expressions.add(new LiteralValueExpression(expressionString.substring(0, startIndex)));
        }
        while (startIndex != -1) {
            int endIndex = DefaultValueExpressionParser.findPlaceholderEndIndex(expressionString, startIndex);
            if (endIndex == -1) {
                throw new ParseException(expressionString, startIndex, "No ending suffix '}' for expression starting at character %d: %s".formatted(startIndex, expressionString.substring(startIndex)));
            }
            int afterClosingParenthesisIndex = endIndex + 1;
            String part = expressionString.substring(startIndex, afterClosingParenthesisIndex);
            if (part.startsWith(PLACEHOLDER_PREFIX)) {
                expressions.add(this.createPlaceholder(part));
            } else {
                expressions.add(this.createExpression(part));
            }
            placerholderIndex = expressionString.indexOf(PLACEHOLDER_PREFIX, endIndex);
            expressionIndex = expressionString.indexOf(EXPRESSION_PREFIX, endIndex);
            startIndex = DefaultValueExpressionParser.getStartIndex(placerholderIndex, expressionIndex);
            if (startIndex == -1) {
                expressions.add(new LiteralValueExpression(expressionString.substring(afterClosingParenthesisIndex)));
                continue;
            }
            expressions.add(new LiteralValueExpression(expressionString.substring(afterClosingParenthesisIndex, startIndex)));
        }
        return new CompositeValueExpression(expressionString, expressions);
    }

    private static int getStartIndex(int placerholderIndex, int expressionIndex) {
        return placerholderIndex != -1 && expressionIndex != -1 ? Math.min(placerholderIndex, expressionIndex) : (placerholderIndex != -1 ? placerholderIndex : expressionIndex);
    }

    private PlaceholderExpression createPlaceholder(String part) {
        return new PlaceholderExpression(part);
    }

    private ExpressionExpression createExpression(String expression) {
        Expression expr = this.configuration.getExpressionParser().parseExpression(expression, ParserContext.TEMPLATE_EXPRESSION);
        ExpressionDependencies dependencies = ExpressionDependencies.discover(expr);
        return new ExpressionExpression(expr, dependencies);
    }

    private static int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        char quotationChar = '\u0000';
        int nestingLevel = 0;
        boolean skipEscape = false;
        for (int index = startIndex + PLACEHOLDER_PREFIX_LENGTH; index < buf.length(); ++index) {
            char c = buf.charAt(index);
            if (!skipEscape && c == '\\') {
                skipEscape = true;
            } else if (skipEscape) {
                skipEscape = false;
            } else if (quotationChar == '\u0000') {
                for (char quoteChar : QUOTE_CHARS) {
                    if (quoteChar != c) continue;
                    quotationChar = c;
                    break;
                }
            } else if (quotationChar == c) {
                quotationChar = '\u0000';
            }
            if (skipEscape || quotationChar != '\u0000') continue;
            if (nestingLevel != 0 && c == '}') {
                nestingLevel = (char)(nestingLevel - 1);
                continue;
            }
            if (c == '{') {
                nestingLevel = (char)(nestingLevel + 1);
                continue;
            }
            if (nestingLevel != 0 || c != '}') continue;
            return index;
        }
        return -1;
    }
}

