/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.expression;

import org.springframework.core.env.Environment;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueExpression;
import org.springframework.expression.EvaluationException;

record PlaceholderExpression(String expression) implements ValueExpression
{
    @Override
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public String evaluate(ValueEvaluationContext context) {
        Environment environment2 = context.getEnvironment();
        if (environment2 != null) {
            try {
                return environment2.resolveRequiredPlaceholders(this.expression);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e.getMessage(), e);
            }
        }
        return this.expression;
    }

    @Override
    public Class<?> getValueType(ValueEvaluationContext context) {
        return String.class;
    }
}

